/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import java.util.StringTokenizer;
import org.jacorb.idl.Declaration;
import org.jacorb.idl.IDLTypes;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.ParseException;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.TypePrefixes;
import org.jacorb.idl.parser;

public class TypePrefixDecl
extends Declaration {
    public ScopedName scopedname;
    public String prefix;

    public TypePrefixDecl(int num) {
        super(num);
    }

    @Override
    public void print(PrintWriter ps) {
    }

    @Override
    public void parse() throws ParseException {
        String rname = this.scopedname.typeName;
        if (!NameTable.isDefined(rname, IDLTypes.MODULE)) {
            StringTokenizer strtok = new StringTokenizer(this.pack_name, ".");
            String[] nameScopes = new String[strtok.countTokens()];
            boolean isModuleFinded = false;
            int count = 0;
            while (strtok.hasMoreTokens()) {
                String name;
                nameScopes[count] = name = strtok.nextToken();
                if (name.equals(rname)) {
                    isModuleFinded = true;
                    break;
                }
                ++count;
            }
            if (isModuleFinded) {
                StringBuffer fullName = new StringBuffer();
                for (int i = 0; i < count + 1; ++i) {
                    fullName.append(nameScopes[i]);
                    fullName.append(".");
                }
                rname = fullName.substring(0, fullName.length() - 1);
            } else {
                parser.error("Module name " + rname + " undefined", this.scopedname.token);
            }
        }
        TypePrefixes.define(rname, this.prefix);
    }
}

