/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.remoting.jmx;

import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import org.nanocontainer.remoting.jmx.DynamicMBeanComponentProvider;
import org.nanocontainer.remoting.jmx.DynamicMBeanProvider;
import org.nanocontainer.remoting.jmx.JMXRegistrationInfo;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.CachingComponentAdapter;
import org.picocontainer.defaults.DecoratingComponentAdapter;

public class JMXExposingComponentAdapter
extends DecoratingComponentAdapter {
    private final MBeanServer mBeanServer;
    private final DynamicMBeanProvider[] providers;

    public JMXExposingComponentAdapter(ComponentAdapter componentAdapter, MBeanServer mBeanServer, DynamicMBeanProvider[] dynamicMBeanProviderArray) throws NullPointerException {
        super(componentAdapter);
        if (mBeanServer == null || dynamicMBeanProviderArray == null) {
            throw new NullPointerException();
        }
        this.mBeanServer = mBeanServer;
        this.providers = dynamicMBeanProviderArray;
    }

    public JMXExposingComponentAdapter(ComponentAdapter componentAdapter, MBeanServer mBeanServer) throws NullPointerException {
        this(componentAdapter, mBeanServer, new DynamicMBeanProvider[]{new DynamicMBeanComponentProvider()});
    }

    public Object getComponentInstance(PicoContainer picoContainer) throws PicoInitializationException, PicoIntrospectionException {
        CachingComponentAdapter cachingComponentAdapter = new CachingComponentAdapter(this.getDelegate());
        Object object = cachingComponentAdapter.getComponentInstance(picoContainer);
        for (int i = 0; i < this.providers.length; ++i) {
            JMXRegistrationInfo jMXRegistrationInfo = this.providers[i].provide(picoContainer, cachingComponentAdapter);
            if (jMXRegistrationInfo == null) continue;
            JMException jMException = null;
            try {
                this.mBeanServer.registerMBean(jMXRegistrationInfo.getMBean(), jMXRegistrationInfo.getObjectName());
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                jMException = instanceAlreadyExistsException;
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                jMException = mBeanRegistrationException;
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                jMException = notCompliantMBeanException;
            }
            if (jMException == null) continue;
            throw new PicoInitializationException("Registering MBean failed", jMException);
        }
        return object;
    }
}

