/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir;

import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.ORBSingleton;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.slf4j.Logger;

public class TypeCodeUtil {
    private static final Map cache = new HashMap();

    public static TypeCode getTypeCode(Class c, Object o, Logger logger) throws ClassNotFoundException {
        return TypeCodeUtil.getTypeCode(c, null, o, null, logger);
    }

    public static TypeCode getTypeCode(Class c, ClassLoader classLoader, Object o, String idlName, Logger logger) throws ClassNotFoundException {
        String typeName = c.getName();
        if (logger.isDebugEnabled()) {
            logger.debug("TypeCodes.getTypeCode for class : " + typeName + " idlName: " + idlName);
        }
        ClassLoader loader = classLoader != null ? classLoader : c.getClassLoader();
        TypeCode _tc = (TypeCode)cache.get(typeName);
        if (_tc != null) {
            return _tc;
        }
        if (idlName != null && (_tc = (TypeCode)cache.get(idlName)) != null) {
            return _tc;
        }
        if (c.isPrimitive()) {
            if (typeName.equals("void")) {
                return ORBSingleton.init().get_primitive_tc(TCKind.tk_void);
            }
            if (typeName.equals("int")) {
                return ORBSingleton.init().get_primitive_tc(TCKind.tk_long);
            }
            if (typeName.equals("long")) {
                return ORBSingleton.init().get_primitive_tc(TCKind.tk_longlong);
            }
            if (typeName.equals("short")) {
                return ORBSingleton.init().get_primitive_tc(TCKind.tk_short);
            }
            if (typeName.equals("float")) {
                return ORBSingleton.init().get_primitive_tc(TCKind.tk_float);
            }
            if (typeName.equals("double")) {
                return ORBSingleton.init().get_primitive_tc(TCKind.tk_double);
            }
            if (typeName.equals("boolean")) {
                return ORBSingleton.init().get_primitive_tc(TCKind.tk_boolean);
            }
            if (typeName.equals("byte")) {
                return ORBSingleton.init().get_primitive_tc(TCKind.tk_octet);
            }
            if (typeName.equals("char")) {
                return ORBSingleton.init().get_primitive_tc(TCKind.tk_char);
            }
            if (typeName.equals("wchar")) {
                return ORBSingleton.init().get_primitive_tc(TCKind.tk_wchar);
            }
            System.err.println("- TypeCode.getTypeCode, primitive class not found " + typeName);
            return null;
        }
        Class<?> tcClass = null;
        Class<?> idlEntity = null;
        try {
            tcClass = Class.forName("org.omg.CORBA.TypeCode", true, loader);
            idlEntity = Class.forName("org.omg.CORBA.portable.IDLEntity", true, loader);
        }
        catch (ClassNotFoundException ce) {
            logger.error("Can't load org.jacorb base classes!", (Throwable)ce);
            throw ce;
        }
        boolean field_size = false;
        if (tcClass.isAssignableFrom(c)) {
            return ORBSingleton.init().get_primitive_tc(TCKind.tk_TypeCode);
        }
        if (idlName != null && idlName.length() > 0) {
            try {
                if (idlName.equals("java.lang.String")) {
                    return ORBSingleton.init().get_primitive_tc(TCKind.tk_string);
                }
                if (idlName.equals("org.omg.CORBA.Boolean")) {
                    return ORBSingleton.init().get_primitive_tc(TCKind.tk_boolean);
                }
                if (idlName.equals("org.omg.CORBA.Byte")) {
                    return ORBSingleton.init().get_primitive_tc(TCKind.tk_octet);
                }
                if (idlName.equals("org.omg.CORBA.Short")) {
                    return ORBSingleton.init().get_primitive_tc(TCKind.tk_short);
                }
                if (idlName.equals("org.omg.CORBA.Long")) {
                    return ORBSingleton.init().get_primitive_tc(TCKind.tk_longlong);
                }
                if (idlName.equals("org.omg.CORBA.Int")) {
                    return ORBSingleton.init().get_primitive_tc(TCKind.tk_long);
                }
                if (idlName.equals("org.omg.CORBA.String")) {
                    return ORBSingleton.init().get_primitive_tc(TCKind.tk_string);
                }
                if (idlName.equals("org.omg.CORBA.Char")) {
                    return ORBSingleton.init().get_primitive_tc(TCKind.tk_char);
                }
                if (idlName.equals("org.omg.CORBA.Float")) {
                    return ORBSingleton.init().get_primitive_tc(TCKind.tk_float);
                }
                if (idlName.equals("org.omg.CORBA.Double")) {
                    return ORBSingleton.init().get_primitive_tc(TCKind.tk_double);
                }
                if (idlName.equals("org.omg.CORBA.Any")) {
                    return ORBSingleton.init().get_primitive_tc(TCKind.tk_any);
                }
                if (idlName.equals("org.omg.CORBA.Object")) {
                    return ORBSingleton.init().get_primitive_tc(TCKind.tk_objref);
                }
                if (idlName.equals("org.omg.CORBA.TypeCode")) {
                    return ORBSingleton.init().get_primitive_tc(TCKind.tk_TypeCode);
                }
                Class<?> type = Class.forName(idlName + "Helper", true, loader);
                return (TypeCode)type.getDeclaredMethod("type", null).invoke(null, (Object[])null);
            }
            catch (ClassNotFoundException cnfe) {
                logger.debug("Caught Exception", (Throwable)cnfe);
                throw new RuntimeException("Could not create TypeCode for: " + c.getName() + ", no helper class for " + idlName);
            }
            catch (Exception e) {
                logger.error("Caught Exception", (Throwable)e);
            }
        }
        if (idlEntity.isAssignableFrom(c)) {
            try {
                Class<?> resultHelperClass = Class.forName(c.getName() + "Helper", true, loader);
                return (TypeCode)resultHelperClass.getDeclaredMethod("type", null).invoke(null, (Object[])null);
            }
            catch (Exception cnfe) {
                logger.error("Caught Exception", (Throwable)cnfe);
                throw new RuntimeException("Could not create TypeCode for: " + c.getName());
            }
        }
        throw new RuntimeException("Could not create TypeCode for: " + c.getName() + ", not an IDLEntity");
    }

    static {
        cache.put("java.lang.String", ORBSingleton.init().get_primitive_tc(TCKind.tk_string));
        cache.put("org.omg.CORBA.String", ORBSingleton.init().get_primitive_tc(TCKind.tk_string));
        cache.put("java.lang.Void", ORBSingleton.init().get_primitive_tc(TCKind.tk_void));
        cache.put("java.lang.Long", ORBSingleton.init().get_primitive_tc(TCKind.tk_longlong));
        cache.put("java.lang.Integer", ORBSingleton.init().get_primitive_tc(TCKind.tk_long));
        cache.put("java.lang.Short", ORBSingleton.init().get_primitive_tc(TCKind.tk_short));
        cache.put("java.lang.Float", ORBSingleton.init().get_primitive_tc(TCKind.tk_float));
        cache.put("java.lang.Double", ORBSingleton.init().get_primitive_tc(TCKind.tk_double));
        cache.put("java.lang.Boolean", ORBSingleton.init().get_primitive_tc(TCKind.tk_boolean));
        cache.put("java.lang.Byte", ORBSingleton.init().get_primitive_tc(TCKind.tk_octet));
        cache.put("org.omg.CORBA.Any", ORBSingleton.init().get_primitive_tc(TCKind.tk_any));
        cache.put("java.lang.Character", ORBSingleton.init().get_primitive_tc(TCKind.tk_char));
        cache.put("org.omg.CORBA.TypeCode", ORBSingleton.init().get_primitive_tc(TCKind.tk_TypeCode));
        cache.put("org.omg.CORBA.Object", ORBSingleton.init().get_primitive_tc(TCKind.tk_objref));
    }
}

