/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.AbstractComponentAdapter;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.ComponentParameter;
import org.picocontainer.defaults.DefaultLifecycleStrategy;
import org.picocontainer.defaults.DelegatingComponentMonitor;
import org.picocontainer.defaults.LifecycleStrategy;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.ThreadLocalCyclicDependencyGuard;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public abstract class InstantiatingComponentAdapter
extends AbstractComponentAdapter
implements LifecycleStrategy {
    protected transient Guard verifyingGuard;
    protected transient Parameter[] parameters;
    protected boolean allowNonPublicClasses;
    protected LifecycleStrategy lifecycleStrategy;

    protected InstantiatingComponentAdapter(Object object, Class clazz, Parameter[] parameterArray, boolean bl, ComponentMonitor componentMonitor, LifecycleStrategy lifecycleStrategy) {
        super(object, clazz, componentMonitor);
        this.checkConcrete();
        if (parameterArray != null) {
            for (int i = 0; i < parameterArray.length; ++i) {
                if (parameterArray[i] != null) continue;
                throw new NullPointerException("Parameter " + i + " is null");
            }
        }
        this.parameters = parameterArray;
        this.allowNonPublicClasses = bl;
        this.lifecycleStrategy = lifecycleStrategy;
    }

    protected InstantiatingComponentAdapter(Object object, Class clazz, Parameter[] parameterArray, boolean bl, ComponentMonitor componentMonitor) {
        this(object, clazz, parameterArray, bl, componentMonitor, new DefaultLifecycleStrategy(componentMonitor));
    }

    protected InstantiatingComponentAdapter(Object object, Class clazz, Parameter[] parameterArray, boolean bl) {
        this(object, clazz, parameterArray, bl, new DelegatingComponentMonitor());
    }

    private void checkConcrete() throws NotConcreteRegistrationException {
        boolean bl;
        boolean bl2 = bl = (this.getComponentImplementation().getModifiers() & 0x400) == 1024;
        if (this.getComponentImplementation().isInterface() || bl) {
            throw new NotConcreteRegistrationException(this.getComponentImplementation());
        }
    }

    protected Parameter[] createDefaultParameters(Class[] classArray) {
        Parameter[] parameterArray = new Parameter[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            parameterArray[i] = ComponentParameter.DEFAULT;
        }
        return parameterArray;
    }

    public void verify(final PicoContainer picoContainer) throws PicoIntrospectionException {
        if (this.verifyingGuard == null) {
            this.verifyingGuard = new Guard(){

                public Object run() {
                    Constructor constructor = InstantiatingComponentAdapter.this.getGreediestSatisfiableConstructor(this.guardedContainer);
                    Class[] classArray = constructor.getParameterTypes();
                    Parameter[] parameterArray = InstantiatingComponentAdapter.this.parameters != null ? InstantiatingComponentAdapter.this.parameters : InstantiatingComponentAdapter.this.createDefaultParameters(classArray);
                    for (int i = 0; i < parameterArray.length; ++i) {
                        parameterArray[i].verify(picoContainer, InstantiatingComponentAdapter.this, classArray[i]);
                    }
                    return null;
                }
            };
        }
        this.verifyingGuard.setArguments(picoContainer);
        this.verifyingGuard.observe(this.getComponentImplementation());
    }

    public void accept(PicoVisitor picoVisitor) {
        super.accept(picoVisitor);
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i].accept(picoVisitor);
            }
        }
    }

    public void start(Object object) {
        this.lifecycleStrategy.start(object);
    }

    public void stop(Object object) {
        this.lifecycleStrategy.stop(object);
    }

    public void dispose(Object object) {
        this.lifecycleStrategy.dispose(object);
    }

    public boolean hasLifecycle(Class clazz) {
        return this.lifecycleStrategy.hasLifecycle(clazz);
    }

    protected Object newInstance(Constructor constructor, Object[] objectArray) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.allowNonPublicClasses) {
            constructor.setAccessible(true);
        }
        return constructor.newInstance(objectArray);
    }

    protected abstract Constructor getGreediestSatisfiableConstructor(PicoContainer var1) throws PicoIntrospectionException, UnsatisfiableDependenciesException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException;

    protected static abstract class Guard
    extends ThreadLocalCyclicDependencyGuard {
        protected PicoContainer guardedContainer;

        protected Guard() {
        }

        protected void setArguments(PicoContainer picoContainer) {
            this.guardedContainer = picoContainer;
        }
    }
}

