/*
 * Decompiled with CFR 0.152.
 */
package csfs.datatransfer.nonblockingnio;

import csfs.datatransfer.nonblockingnio.GettingPathSize;
import csfs.datatransfer.nonblockingnio.ImportState;
import csfs.impl.util.Util;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;

public class ImportHandler {
    private static Map activeImports = new HashMap();
    private FileOutputStream outFile;
    private SocketChannel sourceChannel;
    private FileChannel targetChannel;
    private ImportState state;
    private String filePath;
    private long fileSize;
    private String rootDir;

    public ImportHandler(SocketChannel channel, String rootDir) {
        this.sourceChannel = channel;
        this.rootDir = rootDir;
        this.state = new GettingPathSize(this);
    }

    public void read() throws IOException {
        this.state.read();
    }

    public void close() throws IOException {
        if (this.outFile != null) {
            this.outFile.close();
        }
        if (this.targetChannel != null) {
            this.targetChannel.close();
        }
        if (this.sourceChannel != null) {
            this.sourceChannel.close();
        }
        activeImports.remove(this.sourceChannel);
    }

    public FileChannel getTargetChannel() {
        return this.targetChannel;
    }

    public void changeState(ImportState state) {
        this.state = state;
    }

    public SocketChannel getSourceChannel() {
        return this.sourceChannel;
    }

    public static void createHandler(SocketChannel channel, String rootDir) {
        activeImports.put(channel, new ImportHandler(channel, rootDir));
    }

    public static ImportHandler getHandler(SocketChannel channel) {
        return (ImportHandler)activeImports.get(channel);
    }

    public void setFilePath(String filePath) throws FileNotFoundException {
        this.filePath = this.rootDir + Util.getLocalFileSeparator() + filePath;
        this.outFile = new FileOutputStream(this.filePath);
        this.targetChannel = this.outFile.getChannel();
    }

    public String getFilePath() {
        return this.filePath;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }
}

