/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class BasicComponentParameter
implements Parameter,
Serializable {
    public static final BasicComponentParameter BASIC_DEFAULT = new BasicComponentParameter();
    private Object componentKey;

    public BasicComponentParameter(Object object) {
        this.componentKey = object;
    }

    public BasicComponentParameter() {
    }

    public boolean isResolvable(PicoContainer picoContainer, ComponentAdapter componentAdapter, Class clazz) {
        return this.resolveAdapter(picoContainer, componentAdapter, clazz) != null;
    }

    public Object resolveInstance(PicoContainer picoContainer, ComponentAdapter componentAdapter, Class clazz) {
        ComponentAdapter componentAdapter2 = this.resolveAdapter(picoContainer, componentAdapter, clazz);
        if (componentAdapter2 != null) {
            return picoContainer.getComponentInstance(componentAdapter2.getComponentKey());
        }
        return null;
    }

    public void verify(PicoContainer picoContainer, ComponentAdapter componentAdapter, Class clazz) {
        ComponentAdapter componentAdapter2 = this.resolveAdapter(picoContainer, componentAdapter, clazz);
        if (componentAdapter2 == null) {
            HashSet<Class> hashSet = new HashSet<Class>();
            hashSet.add(clazz);
            throw new UnsatisfiableDependenciesException(componentAdapter, hashSet, picoContainer);
        }
        componentAdapter2.verify(picoContainer);
    }

    public void accept(PicoVisitor picoVisitor) {
        picoVisitor.visitParameter(this);
    }

    private ComponentAdapter resolveAdapter(PicoContainer picoContainer, ComponentAdapter componentAdapter, Class clazz) {
        ComponentAdapter componentAdapter2 = this.getTargetAdapter(picoContainer, clazz, componentAdapter);
        if (componentAdapter2 == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(componentAdapter2.getComponentImplementation())) {
            if (clazz.isPrimitive()) {
                try {
                    Field field = componentAdapter2.getComponentImplementation().getField("TYPE");
                    Class clazz2 = (Class)field.get(componentAdapter2.getComponentInstance(null));
                    if (clazz.isAssignableFrom(clazz2)) {
                        return componentAdapter2;
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return null;
        }
        return componentAdapter2;
    }

    private ComponentAdapter getTargetAdapter(PicoContainer picoContainer, Class clazz, ComponentAdapter componentAdapter) {
        if (this.componentKey != null) {
            return picoContainer.getComponentAdapter(this.componentKey);
        }
        if (componentAdapter == null) {
            return picoContainer.getComponentAdapterOfType(clazz);
        }
        Object object = componentAdapter.getComponentKey();
        ComponentAdapter componentAdapter2 = picoContainer.getComponentAdapter(clazz);
        if (componentAdapter2 != null && !object.equals(componentAdapter2.getComponentKey())) {
            return componentAdapter2;
        }
        List list = picoContainer.getComponentAdaptersOfType(clazz);
        ComponentAdapter componentAdapter3 = null;
        Object[] objectArray = list.iterator();
        while (objectArray.hasNext()) {
            ComponentAdapter componentAdapter4 = (ComponentAdapter)objectArray.next();
            if (!componentAdapter4.getComponentKey().equals(object)) continue;
            componentAdapter3 = componentAdapter4;
        }
        list.remove(componentAdapter3);
        if (list.size() == 0) {
            if (picoContainer.getParent() != null) {
                return picoContainer.getParent().getComponentAdapterOfType(clazz);
            }
            return null;
        }
        if (list.size() == 1) {
            return (ComponentAdapter)list.get(0);
        }
        objectArray = new Class[list.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = ((ComponentAdapter)list.get(i)).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(clazz, objectArray);
    }
}

