/*
 * Decompiled with CFR 0.152.
 */
package csfs.impl.channel;

import csfs.impl.filetracker.FileTracker;
import csfs.impl.filetracker.FileTrackerLeasing;
import csfs.remote.ClosedChannelException;
import csfs.remote.InvalidStateException;
import csfs.remote.OctetSequenceHolder;
import csfs.remote.RandomAccessChannelPOA;
import csfs.remote.RemoteFile;
import csfs.remote.RemoteFileHelper;
import csfs.remote.ServerException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;

public class RandomAccessChannelDefaultServantImpl
extends RandomAccessChannelPOA {
    @Override
    public void seek(long num) throws ClosedChannelException, InvalidStateException, ServerException {
        RandomAccessFile raf = this.getRandomAccessFile();
        if (raf != null) {
            try {
                raf.seek(Math.max(0L, num));
            }
            catch (IOException exc) {
                exc.printStackTrace();
                throw new InvalidStateException("Unable to perform seek operation: " + exc.getMessage(), this.getFile().getFullName());
            }
        } else {
            throw new ClosedChannelException(this._this());
        }
    }

    @Override
    public long skip(long num) throws ClosedChannelException, InvalidStateException, ServerException {
        long pointer;
        long seek = -1L;
        RandomAccessFile raf = this.getRandomAccessFile();
        if (raf != null) {
            try {
                pointer = raf.getFilePointer();
                if (num < 0L - pointer) {
                    seek = 0L;
                }
                if (num + pointer > raf.length()) {
                    seek = raf.length();
                }
                if (seek == -1L) {
                    seek = pointer + num;
                }
                raf.seek(seek);
            }
            catch (IOException exc) {
                exc.printStackTrace();
                throw new InvalidStateException("Unable to perform skip operation: " + exc.getMessage(), this.getFile().getFullName());
            }
        } else {
            throw new ClosedChannelException(this._this());
        }
        return seek -= pointer;
    }

    @Override
    public int read(int size, OctetSequenceHolder buffer) throws ClosedChannelException, InvalidStateException, ServerException {
        int responseLength = 0;
        RandomAccessFile raf = this.getRandomAccessFile();
        if (raf != null) {
            try {
                responseLength = (int)Math.min((long)size, raf.length() - raf.getFilePointer());
                byte[] response = new byte[responseLength];
                int read = 0;
                int bytesRead = 0;
                while (read < responseLength && bytesRead != -1) {
                    bytesRead = raf.read(response, read, responseLength - read);
                    if (bytesRead == -1) continue;
                    read += bytesRead;
                }
                if (read != responseLength) {
                    throw new InvalidStateException("Could NOT read expected " + responseLength + " bytes", this.getFile().getFullName());
                }
                buffer.value = response;
            }
            catch (IOException exc) {
                exc.printStackTrace();
                throw new InvalidStateException("Unable to perform read operation: " + exc.getMessage(), this.getFile().getFullName());
            }
        } else {
            throw new ClosedChannelException(this._this());
        }
        return responseLength;
    }

    @Override
    public int write(int size, byte[] buffer) throws ClosedChannelException, InvalidStateException, ServerException {
        int response = 0;
        RandomAccessFile raf = this.getRandomAccessFile();
        if (raf != null) {
            try {
                raf.write(buffer, 0, size);
                response = size;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else {
            throw new ClosedChannelException(this._this());
        }
        return response;
    }

    @Override
    public boolean isOpen() throws InvalidStateException, ServerException {
        return this.getRandomAccessFile() != null;
    }

    @Override
    public RemoteFile getFile() throws InvalidStateException, ServerException {
        String channelID = this.getObjectId();
        String fileID = channelID.substring(0, channelID.lastIndexOf(95));
        return this.createRemoteFile(fileID);
    }

    @Override
    public void close() throws InvalidStateException, ServerException {
        FileTracker tracker = FileTrackerLeasing.getInstance();
        tracker.removeFileDescriptor(this.getObjectId());
    }

    private RandomAccessFile getRandomAccessFile() throws InvalidStateException, ServerException {
        return (RandomAccessFile)FileTrackerLeasing.getInstance().getFileDescriptor(this.getObjectId());
    }

    private String getObjectId() throws InvalidStateException {
        return new String(this._object_id());
    }

    private RemoteFile createRemoteFile(String path) throws InvalidStateException, ServerException {
        Object o = null;
        try {
            o = this._poa().the_parent().create_reference_with_id(path.getBytes(), RemoteFileHelper.type().id());
        }
        catch (UserException ex) {
            ex.printStackTrace();
            throw new InvalidStateException("Internal misconfiguration problem: " + ex.getMessage(), this.getFile().getFullName());
        }
        return RemoteFileHelper.narrow(o);
    }
}

