/*
 * Decompiled with CFR 0.152.
 */
package csfs.datatransfer.nonblockingnio;

import csfs.datatransfer.nonblockingnio.GettingPath;
import csfs.datatransfer.nonblockingnio.ImportHandler;
import csfs.datatransfer.nonblockingnio.ImportState;
import java.io.IOException;
import java.nio.ByteBuffer;

public class GettingPathSize
extends ImportState {
    public static final int HEADER_SIZE = 4;
    private ByteBuffer buffer = ByteBuffer.allocate(4);

    public GettingPathSize(ImportHandler handler) {
        this.remainingBytes = 4L;
        this.handler = handler;
    }

    @Override
    public void read() throws IOException {
        int bytesRead = this.handler.getSourceChannel().read(this.buffer);
        this.decRemainingBytes(bytesRead);
    }

    @Override
    protected void decRemainingBytes(long value) throws IOException {
        this.remainingBytes -= value;
        if (this.remainingBytes == 0L) {
            this.buffer.flip();
            int pathSize = this.buffer.getInt();
            this.handler.changeState(new GettingPath(this.handler, pathSize));
        }
    }
}

