/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.jacorb.idl.AnyType;
import org.jacorb.idl.ArrayDeclarator;
import org.jacorb.idl.BaseType;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Environment;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.IDLTypes;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.ParseException;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.VectorType;
import org.jacorb.idl.parser;

public class ArrayTypeSpec
extends VectorType {
    ArrayDeclarator declarator = null;
    String dimensionStr = "";
    public int[] dims = null;
    int my_dim = 0;
    private boolean written = false;

    public ArrayTypeSpec(int num, TypeSpec elem, ArrayDeclarator ad, String pack_name) {
        super(num);
        this.declarator = ad;
        this.name = this.declarator.name();
        this.set_token(ad.get_token());
        this.setEnclosingSymbol(ad.getEnclosingSymbol());
        this.pack_name = pack_name;
        this.type_spec = elem;
        if (parser.logger.isLoggable(Level.ALL)) {
            parser.logger.log(Level.ALL, "ArrayTypeSpec with declarator " + ad.name());
        }
    }

    private ArrayTypeSpec(int num, TypeSpec elem, ArrayDeclarator ad, String pack_name, int my_dim) {
        super(num);
        this.declarator = ad;
        this.name = this.declarator.name();
        this.dims = this.declarator.dimensions();
        this.set_token(ad.get_token());
        this.setEnclosingSymbol(ad.getEnclosingSymbol());
        this.pack_name = pack_name;
        this.my_dim = my_dim;
        this.type_spec = this.dims.length > my_dim + 1 ? new ArrayTypeSpec(ArrayTypeSpec.new_num(), elem, ad, pack_name, my_dim + 1) : elem;
        StringBuffer sb = new StringBuffer();
        for (int i = my_dim; i < this.dims.length; ++i) {
            sb.append("[]");
        }
        this.dimensionStr = sb.toString();
    }

    @Override
    public Object clone() {
        ArrayTypeSpec st = new ArrayTypeSpec(ArrayTypeSpec.new_num(), this.type_spec, this.declarator, this.pack_name);
        st.dims = this.dims;
        st.included = this.included;
        st.typedefd = this.typedefd;
        st.inhibitionFlag = this.inhibitionFlag;
        st.dims = this.dims;
        st.my_dim = this.my_dim;
        st.dimensionStr = this.dimensionStr;
        st.set_token(this.get_token());
        st.setEnclosingSymbol(this.getEnclosingSymbol());
        return st;
    }

    @Override
    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
    }

    @Override
    public TypeSpec typeSpec() {
        return this;
    }

    @Override
    public void setPackage(String s) {
        s = parser.pack_replace(s);
        throw new RuntimeException("ArrayTypeSpec.setPackage should never be called!");
    }

    @Override
    public void markTypeDefd() {
        this.typedefd = true;
    }

    @Override
    public void parse() throws ParseException {
        TypeSpec ts;
        if (parser.logger.isLoggable(Level.ALL)) {
            parser.logger.log(Level.ALL, "ArrayTypeSpec.parse " + this.declarator.name());
        }
        this.dims = this.declarator.dimensions();
        if (this.dims.length > 1) {
            this.type_spec = new ArrayTypeSpec(ArrayTypeSpec.new_num(), this.type_spec, this.declarator, this.pack_name, 1);
        } else if (this.type_spec.typeSpec() instanceof ConstrTypeSpec) {
            this.type_spec.parse();
        } else if (this.type_spec.typeSpec() instanceof ScopedName && (ts = ((ScopedName)this.type_spec.typeSpec()).resolvedTypeSpec()) != null) {
            this.type_spec = ts;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = this.my_dim; i < this.dims.length; ++i) {
            sb.append("[]");
        }
        this.dimensionStr = sb.toString();
        try {
            if (!this.typedefd) {
                NameTable.define(this.full_name(), IDLTypes.TYPE);
                if (!NameTable.isDefined(this.typeName(), IDLTypes.TYPE)) {
                    NameTable.define(this.typeName(), IDLTypes.TYPE);
                }
            }
        }
        catch (NameAlreadyDefined n) {
            parser.fatal_error("Name " + this.full_name() + " already defined.", null);
        }
    }

    @Override
    public String getTypeCodeExpression() {
        return this.getTypeCodeExpression(new HashSet());
    }

    @Override
    public String getTypeCodeExpression(Set knownTypes) {
        String originalType = "org.omg.CORBA.ORB.init().create_array_tc(" + this.dims[this.my_dim] + "," + this.elementTypeSpec().getTypeCodeExpression(knownTypes) + ")";
        return originalType;
    }

    @Override
    public int getTCKind() {
        return 20;
    }

    @Override
    public String helperName() {
        return ScopedName.unPseudoName(this.full_name()) + "Helper";
    }

    @Override
    public String holderName() {
        return ScopedName.unPseudoName(this.full_name()) + "Holder";
    }

    public String className() {
        String cName;
        String fullName = this.pack_name.length() > 0 ? ScopedName.unPseudoName(this.pack_name + "." + this.name) : ScopedName.unPseudoName(this.name);
        if (fullName.indexOf(46) > 0) {
            this.pack_name = fullName.substring(0, fullName.lastIndexOf(46));
            cName = fullName.substring(fullName.lastIndexOf(46) + 1);
        } else {
            this.pack_name = "";
            cName = fullName;
        }
        return cName;
    }

    @Override
    public int length() {
        return this.dims[this.my_dim];
    }

    @Override
    public String printReadStatement(String var_name, String streamname) {
        if (parser.logger.isLoggable(Level.WARNING)) {
            parser.logger.log(Level.WARNING, "Array printReadStatement");
        }
        StringBuffer sb = new StringBuffer();
        String type = this.typeName();
        sb.append(var_name + " = new " + type.substring(0, type.indexOf("[")));
        sb.append("[" + this.length() + "]");
        sb.append(type.substring(type.indexOf(93) + 1) + ";" + Environment.NL);
        if (this.elementTypeSpec() instanceof BaseType && !(this.elementTypeSpec() instanceof AnyType)) {
            String _tmp = this.elementTypeSpec().printReadExpression(streamname);
            sb.append("\t\t" + _tmp.substring(0, _tmp.indexOf("(")) + "_array(" + var_name + ",0," + this.length() + ");");
        } else {
            char idx_variable = 'i';
            String indent = "";
            if (var_name.endsWith("]")) {
                idx_variable = (char)(var_name.charAt(var_name.length() - 2) + '\u0001');
                indent = "    ";
            }
            sb.append("\t\t" + indent + "for (int " + idx_variable + "=0;" + idx_variable + "<" + this.length() + ";" + idx_variable + "++)" + Environment.NL + "\t\t" + indent + "{" + Environment.NL);
            sb.append("\t\t\t" + indent + this.elementTypeSpec().printReadStatement(var_name + "[" + idx_variable + "]", streamname) + Environment.NL);
            sb.append("\t\t" + indent + "}" + Environment.NL);
        }
        return sb.toString();
    }

    @Override
    public String printWriteStatement(String var_name, String streamname) {
        StringBuffer sb = new StringBuffer();
        sb.append("\t\tif (" + var_name + ".length<" + this.length() + ")" + Environment.NL + "\t\t\tthrow new org.omg.CORBA.MARSHAL(\"Incorrect array size \"+" + var_name + ".length+\", expecting " + this.length() + "\");" + Environment.NL);
        if (this.elementTypeSpec() instanceof BaseType && !(this.elementTypeSpec() instanceof AnyType)) {
            String _tmp = this.elementTypeSpec().printWriteStatement(var_name, streamname);
            sb.append("\t\t" + _tmp.substring(0, _tmp.indexOf("(")) + "_array(" + var_name + ",0," + this.length() + ");");
        } else {
            char idx_variable = 'i';
            String indent = "";
            if (var_name.endsWith("]")) {
                idx_variable = (char)(var_name.charAt(var_name.length() - 2) + '\u0001');
                indent = "    ";
            }
            sb.append("\t\t" + indent + "for (int " + idx_variable + "=0; " + idx_variable + "<" + this.length() + ";" + idx_variable + "++)" + Environment.NL + "\t\t" + indent + "{" + Environment.NL);
            sb.append("\t\t\t" + indent + this.elementTypeSpec().printWriteStatement(var_name + "[" + idx_variable + "]", streamname) + Environment.NL);
            sb.append("\t\t" + indent + "}" + Environment.NL);
        }
        return sb.toString();
    }

    private void printHolderClass(String className, PrintWriter ps) {
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";" + Environment.NL);
        }
        String type = this.typeName();
        ps.println("public" + parser.getFinalString() + " class " + className + "Holder");
        ps.println("\timplements org.omg.CORBA.portable.Streamable");
        ps.println("{");
        ps.println("\tpublic " + type + " value;");
        ps.println("\tpublic " + className + "Holder ()");
        ps.println("\t{");
        ps.println("\t}");
        ps.println("\tpublic " + className + "Holder (final " + type + " initial)" + Environment.NL + "\t{");
        ps.println("\t\tvalue = initial;");
        ps.println("\t}");
        ps.println("\tpublic org.omg.CORBA.TypeCode _type ()");
        ps.println("\t{");
        ps.println("\t\treturn " + className + "Helper.type ();");
        ps.println("\t}");
        ps.println("\tpublic void _read (final org.omg.CORBA.portable.InputStream _in)");
        ps.println("\t{");
        ps.println("\t\tvalue = " + className + "Helper.read (_in);");
        ps.println("\t}");
        ps.println("\tpublic void _write (final org.omg.CORBA.portable.OutputStream _out)");
        ps.println("\t{");
        ps.println("\t\t" + className + "Helper.write (_out,value);");
        ps.println("\t}");
        ps.println("}");
    }

    private void printHelperClass(String className, PrintWriter ps) {
        String _tmp;
        if (!this.pack_name.equals("")) {
            ps.println("package " + this.pack_name + ";");
        }
        String type = this.typeName();
        ps.println("public abstract class " + className + "Helper");
        ps.println("{");
        ps.println("\tprivate static org.omg.CORBA.TypeCode _type = " + this.getTypeCodeExpression() + ";");
        TypeSpec.printHelperClassMethods(ps, type);
        this.printIdMethod(ps);
        ps.println("\tpublic static " + type + " read (final org.omg.CORBA.portable.InputStream _in)");
        ps.println("\t{");
        ps.print("\t\t" + type + " result = new " + type.substring(0, type.indexOf(91)) + "[" + this.length() + "]");
        ps.println(type.substring(type.indexOf(93) + 1) + "; // " + type);
        if (this.elementTypeSpec() instanceof BaseType && !(this.elementTypeSpec() instanceof AnyType)) {
            _tmp = this.elementTypeSpec().printReadExpression("_in");
            ps.println("\t\t" + _tmp.substring(0, _tmp.indexOf("(")) + "_array(result,0," + this.length() + ");");
        } else {
            ps.println("\t\tfor (int i = 0; i < " + this.length() + "; i++)" + Environment.NL + "\t\t{");
            ps.println("\t\t\t" + this.elementTypeSpec().printReadStatement("result[i]", "_in") + Environment.NL + "\t\t}");
        }
        ps.println("\t\treturn result;");
        ps.println("\t}");
        ps.println("\tpublic static void write (final org.omg.CORBA.portable.OutputStream out, final " + type + " s)");
        ps.println("\t{");
        if (this.declarator.dimensions()[0] != 0) {
            ps.println("\t\tif (s.length != " + this.declarator.dimensions()[0] + ")");
            ps.println("\t\t\tthrow new org.omg.CORBA.MARSHAL(\"Incorrect array size\");");
        }
        if (this.elementTypeSpec() instanceof BaseType && !(this.elementTypeSpec() instanceof AnyType)) {
            _tmp = this.elementTypeSpec().printWriteStatement("s", "out");
            ps.println("\t\t" + _tmp.substring(0, _tmp.indexOf("(")) + "_array(s,0," + this.length() + ");");
        } else {
            ps.println("\t\tfor (int i = 0; i < s.length; i++)" + Environment.NL + "\t\t{");
            ps.println("\t\t\t" + this.elementTypeSpec().printWriteStatement("s[i]", "out") + Environment.NL + "\t\t}");
        }
        ps.println("\t}");
        ps.println("}");
    }

    @Override
    public void print(PrintWriter _ps) {
        if (this.included && !this.generateIncluded()) {
            return;
        }
        try {
            this.type_spec.print(_ps);
            if (!this.written && this.typedefd) {
                PrintWriter ps;
                String fname;
                File f;
                String className = this.className();
                String path = parser.out_dir + fileSeparator + this.pack_name.replace('.', fileSeparator);
                File dir = new File(path);
                if (!dir.exists() && !dir.mkdirs()) {
                    parser.fatal_error("Unable to create " + path, null);
                }
                if (GlobalInputStream.isMoreRecentThan(f = new File(dir, fname = className + "Holder.java"))) {
                    ps = new PrintWriter(new FileWriter(f));
                    this.printHolderClass(className, ps);
                    ps.close();
                }
                if (GlobalInputStream.isMoreRecentThan(f = new File(dir, fname = className + "Helper.java"))) {
                    ps = new PrintWriter(new FileWriter(f));
                    this.printHelperClass(className, ps);
                    ps.close();
                }
                this.written = true;
            }
        }
        catch (IOException i) {
            throw new RuntimeException("File IO error" + i);
        }
    }

    @Override
    public void printInsertIntoAny(PrintWriter ps, String anyname, String varname) {
        String helpername = this.className() + "Helper";
        ps.println("\t\t" + this.pack_name + "." + helpername + ".insert(" + anyname + ", " + varname + " );");
    }

    @Override
    public void printExtractResult(PrintWriter ps, String resultname, String anyname, String resulttype) {
        throw new RuntimeException("DII-stubs not completely implemented for array types!");
    }
}

