-------------------------------------------------------------------------
-- $Author: fpina $
-- $Revision: 159864 $  - $Date: 2014-12-11 10:01:07 -0200 (Thu, 11 Dec 2014) $
-------------------------------------------------------------------------

local Verbose = require "loop.debug.Verbose"
local verbose = Verbose{
  groups = {
    --
    -- architectural levels
    --
    {"basic", "services", "commands"}, -- Nivel 1
    {"csfs", "platform"}, -- Nvel 2
    -- {"platform"},
    {"debug"},
    --
    -- aspect selections
    --
    basic = { "init", "error" },
    services = { "top", "kill" },
    commands = { "cmdcomp", "cmdretr", "cmdexec", "cmdinfo", "cmdkill" },
    platform = { "platmsg", "platcmd", "platerror" },
    },
}

sga = sga or {}
sga.verbose = verbose
package.loaded["sga.verbose"] = verbose

-- verbose:Timed = "%d/%m %H:%M:%S"
verbose:settimeformat("%d/%m/%y %H:%M:%S")
verbose.timed = true
--verbose:Timed.services = true
--verbose:Timed = {service = true}

if servermanager then
  servermanager.writeError = function(msg)
    verbose:platerror(msg)
  end

  servermanager.writeMsg = function(msg)
    verbose:platmsg(msg)
  end

  servermanager.writeCmd = function(msg)
    verbose:platcmd(msg)
  end
end

verbose:level(2)
