/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir.gui.typesystem.remote;

import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.ir.gui.typesystem.Interface;
import org.jacorb.ir.gui.typesystem.ModelParticipant;
import org.jacorb.ir.gui.typesystem.TypeSystemNode;
import org.jacorb.ir.gui.typesystem.Value;
import org.jacorb.ir.gui.typesystem.remote.IRAttribute;
import org.jacorb.ir.gui.typesystem.remote.IRConstant;
import org.jacorb.ir.gui.typesystem.remote.IRContainer;
import org.jacorb.ir.gui.typesystem.remote.IRException;
import org.jacorb.ir.gui.typesystem.remote.IRInterface;
import org.jacorb.ir.gui.typesystem.remote.IROperation;
import org.jacorb.ir.gui.typesystem.remote.IRTypedef;
import org.jacorb.ir.gui.typesystem.remote.IRValueMember;
import org.jacorb.ir.gui.typesystem.remote.RemoteTypeSystem;
import org.omg.CORBA.IRObject;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.Object;
import org.omg.CORBA.ValueDef;
import org.omg.CORBA.ValueDefHelper;

public class IRValue
extends IRContainer
implements Value {
    private Value baseValue = null;
    private boolean lookedUpBaseValue = false;
    private Value[] abstractBaseValues = null;
    private IRInterface[] interfaces = null;
    private IRAttribute[] allFields = null;
    private IROperation[] allOperations = null;
    private IRValueMember[] allMembers = null;

    public IRValue() {
    }

    public IRValue(IRObject irObject) {
        super(irObject);
    }

    @Override
    public String[] allowedToAdd() {
        String[] result = new String[]{IRAttribute.nodeTypeName(), IROperation.nodeTypeName(), IRConstant.nodeTypeName(), IRTypedef.nodeTypeName(), IRException.nodeTypeName(), IRValueMember.nodeTypeName()};
        return result;
    }

    @Override
    public String description() {
        Value[] abstractBases;
        String result = super.description();
        Value base = this.getBaseValue();
        result = base != null ? result + "\nBase-Value:\t " + ((IRValue)base).getAbsoluteName() : result + "\nBase-Value:\t:none";
        Interface[] implemented = this.getInterfaces();
        if (implemented.length > 0) {
            result = result + "\nImplemented-Interfaces:\t ";
            for (int i = 0; i < implemented.length; ++i) {
                result = result + ((TypeSystemNode)((java.lang.Object)implemented[i])).getAbsoluteName();
                if (i == implemented.length - 1) continue;
                result = result + ", ";
            }
        } else {
            result = result + "\nImplemented-Interfaces:\t:none";
        }
        if ((abstractBases = this.getAbstractBaseValues()).length > 0) {
            result = result + "\nAbstract-Base-Values:\t ";
            for (int i = 0; i < abstractBases.length; ++i) {
                result = result + ((TypeSystemNode)((java.lang.Object)abstractBases[i])).getAbsoluteName();
                if (i == abstractBases.length - 1) continue;
                result = result + ", ";
            }
        } else {
            result = result + "\nAbstract-Base-Values:\t:none";
        }
        return result;
    }

    @Override
    public TypeSystemNode[] getAllFields() {
        if (this.allFields == null) {
            int i;
            Vector<ModelParticipant> fields = new Vector<ModelParticipant>();
            Interface[] interfaces = this.getInterfaces();
            for (int i2 = 0; i2 < interfaces.length; ++i2) {
                TypeSystemNode[] nextFields = interfaces[i2].getAllFields();
                for (int n = 0; n < nextFields.length; ++n) {
                    fields.addElement(nextFields[n]);
                }
            }
            Value[] abstractBases = this.getAbstractBaseValues();
            for (int i3 = 0; i3 < abstractBases.length; ++i3) {
                TypeSystemNode[] nextFields = abstractBases[i3].getAllFields();
                for (int n = 0; n < nextFields.length; ++n) {
                    if (!(nextFields[n] instanceof IRAttribute)) continue;
                    fields.addElement(nextFields[n]);
                }
            }
            ModelParticipant[] contained = this.contents();
            for (i = 0; i < contained.length; ++i) {
                if (!(contained[i] instanceof IRAttribute)) continue;
                fields.addElement(contained[i]);
            }
            this.allFields = new IRAttribute[fields.size()];
            i = 0;
            Enumeration e = fields.elements();
            while (e.hasMoreElements()) {
                this.allFields[i] = (IRAttribute)e.nextElement();
                ++i;
            }
        }
        return this.allFields;
    }

    @Override
    public TypeSystemNode[] getAllOperations() {
        if (this.allOperations == null) {
            int i;
            Vector<ModelParticipant> operations = new Vector<ModelParticipant>();
            Interface[] interfaces = this.getInterfaces();
            for (int i2 = 0; i2 < interfaces.length; ++i2) {
                TypeSystemNode[] nextOperations = interfaces[i2].getAllOperations();
                for (int n = 0; n < nextOperations.length; ++n) {
                    operations.addElement(nextOperations[n]);
                }
            }
            ModelParticipant[] contents = this.contents();
            for (i = 0; i < contents.length; ++i) {
                if (!(contents[i] instanceof IROperation)) continue;
                operations.addElement(contents[i]);
            }
            this.allOperations = new IROperation[operations.size()];
            i = 0;
            Enumeration e = operations.elements();
            while (e.hasMoreElements()) {
                this.allOperations[i] = (IROperation)e.nextElement();
                ++i;
            }
        }
        return this.allOperations;
    }

    @Override
    public Value getBaseValue() {
        if (!this.lookedUpBaseValue) {
            ValueDef valueDef = ValueDefHelper.narrow((Object)this.irObject);
            ValueDef base = valueDef.base_value();
            if (base != null) {
                this.baseValue = (Value)((java.lang.Object)RemoteTypeSystem.createTypeSystemNode(base));
            }
            this.lookedUpBaseValue = true;
        }
        return this.baseValue;
    }

    public Value[] getAbstractBaseValues() {
        if (this.abstractBaseValues == null) {
            ValueDef valueDef = ValueDefHelper.narrow((Object)this.irObject);
            ValueDef[] abstractBases = valueDef.abstract_base_values();
            this.abstractBaseValues = new Value[abstractBases.length];
            for (int i = 0; i < abstractBases.length; ++i) {
                this.abstractBaseValues[i] = (Value)((java.lang.Object)RemoteTypeSystem.createTypeSystemNode(abstractBases[i]));
            }
        }
        return this.abstractBaseValues;
    }

    @Override
    public TypeSystemNode[] getAllMembers() {
        if (this.allMembers == null) {
            int i;
            int i2;
            Vector<ModelParticipant> members = new Vector<ModelParticipant>();
            Value base = this.getBaseValue();
            if (base != null) {
                TypeSystemNode[] baseMembers = base.getAllMembers();
                for (i2 = 0; i2 < baseMembers.length; ++i2) {
                    members.addElement(baseMembers[i2]);
                }
            }
            Value[] abstractBases = this.getAbstractBaseValues();
            for (i2 = 0; i2 < abstractBases.length; ++i2) {
                TypeSystemNode[] nextMembers = abstractBases[i2].getAllMembers();
                for (int n = 0; n < nextMembers.length; ++n) {
                    members.addElement(nextMembers[n]);
                }
            }
            ModelParticipant[] contents = this.contents();
            for (i = 0; i < contents.length; ++i) {
                if (!(contents[i] instanceof IRValueMember)) continue;
                members.addElement(contents[i]);
            }
            this.allMembers = new IRValueMember[members.size()];
            i = 0;
            Enumeration e = members.elements();
            while (e.hasMoreElements()) {
                this.allMembers[i] = (IRValueMember)e.nextElement();
                ++i;
            }
        }
        return this.allMembers;
    }

    @Override
    public Interface[] getInterfaces() {
        if (this.interfaces == null) {
            ValueDef valueDef = ValueDefHelper.narrow((Object)this.irObject);
            InterfaceDef[] supportedInterfaces = valueDef.supported_interfaces();
            this.interfaces = new IRInterface[supportedInterfaces.length];
            for (int i = 0; i < supportedInterfaces.length; ++i) {
                IRInterface intf;
                this.interfaces[i] = intf = (IRInterface)RemoteTypeSystem.createTypeSystemNode(supportedInterfaces[i]);
            }
        }
        return this.interfaces;
    }

    public static String nodeTypeName() {
        return "value";
    }

    @Override
    protected void setIRObject(IRObject irObject) {
        super.setIRObject(irObject);
    }
}

