package csdk.v2.api.application;

/**
 * Representao da aplicao remetente de uma {@link IMessage mensagem}.
 */
public interface IMessageSender {

  /**
   * Obtm o tipo da aplicao que enviou a mensagem.
   * 
   * @return o tipo da aplicao.
   */
  public String getApplicationType();

  /**
   * Obtm o identificador nico da instncia da aplicao que enviou a
   * mensagem.
   * 
   * @return o identificador da instncia.
   */
  public String getApplicationInstanceId();

}
