package csdk.v2.api.command;

import java.awt.Window;

import csdk.v2.api.core.IContext;

/**
 * Define os mtodos disponveis para acesso da aplicao  execuo de
 * comandos.
 */
public interface ICommandContext extends IContext {

  /**
   * Executa um algoritmo, dado o nome e identificador da verso, configurando-o
   * com os valores de parmetros especificados.
   * 
   * @param template definio do algoritmo a ser executado e dos valores dos
   *        seus parmetros
   * @param cmdDescription descrio do comando
   * @param sgaName nome do servidor de execuo (SGA) a ser usado para
   *        execuo. Se for {@code null}, indica que a seleo do servidor
   *        ser feita automaticamente pelo ambiente.
   * @param window janela-me da execuo.
   * @param observer Observador do comando executado.
   * 
   * @return o identificador do comando submetido.
   * 
   * @throws CommandException em caso de erro durante a submisso do comando.
   */
  public String executeAlgorithm(IAlgorithmTemplate template,
    String cmdDescription, String sgaName, Window window,
    ICommandObserver observer) throws CommandException;

  /**
   * Executa um fluxo de algoritmos, dado o nome e identificador da verso ou o
   * arquivo de definio do fluxo, configurando-o com os valores de parmetros
   * especificados.
   * 
   * @param template definio do fluxo a ser executado e dos valores dos seus
   *        parmetros
   * @param cmdDescription descrio do comando
   * @param sgaName nome do servidor de execuo (SGA) a ser usado para
   *        execuo. Se for {@code null}, indica que a seleo do servidor
   *        ser feita automaticamente pelo ambiente.
   * @param window janela-me da execuo.
   * @param observer Observador do comando executado.
   * 
   * @return o identificador do comando submetido.
   * 
   * @throws CommandException em caso de erro durante a submisso do comando.
   */
  public String executeFlow(IFlowTemplate template, String cmdDescription,
    String sgaName, Window window, ICommandObserver observer)
    throws CommandException;

}
