package csdk.v2.api.command;

import java.util.Date;

/**
 * Informaes obtidas de um comando executado.
 */
public interface ICommandInfo {

  /**
   * Enumerao dos possveis tipos de finalizao de um comando.
   */
  public enum FinalizationType {

    /** Indica que um comando foi perdido. */
    LOST,
    /** Indica que um comando foi abortado. */
    KILLED,
    /** Indica que um comando nao foi iniciado. */
    INIT_FAILURE,
    /**
     * Indica que um comando terminou mas no foi configurado para informar o
     * cdigo de retorno.
     */
    COMPLETED,
    /** Indica que um comando terminou com erro. */
    ERROR,
    /** Indica que um comando terminou com sucesso. */
    SUCCESS,
    /**
     * Indica que um comando terminou, deveria informar o cdigo de retorno, mas
     * no foi possvel ler esse cdigo, para determinar se foi bem sucedido.
     */
    NO_CODE;
  }

  /**
   * Obtm o identificador do comando.
   * 
   * @return o identificador.
   */
  public String getCommandId();

  /**
   * Obtm a descrio do comando.
   * 
   * @return A descrio.
   */
  public String getDescription();

  /**
   * Obtm o identificador do projeto sobre o qual o comando  executado.
   * 
   * @return o identificador do projeto.
   */
  public String getProjectId();

  /**
   * Obtm o tipo de finalizao do comando.
   * 
   * @return O tipo de finalizao.
   */
  public FinalizationType getFinalizationType();

  /**
   * Obtm o cdigo de sada do comando, se esse estiver sido informado ou
   * {@code null} caso contrrio.
   * 
   * @return o cdigo de sada ou {@code null}.
   */
  public Integer getExitCode();

  /**
   * Obtm o identificador do n responsvel por erro na execuo de um fluxo ou
   * {@code null} caso no haja erro ou no seja um comando do tipo fluxo.
   * 
   * @return o identificador do n.
   */
  public Integer getGuiltyNodeId();

  /**
   * Obtm o horrio de incio da execuo do comando.
   * 
   * @return o horrio no padro {@link Date#getTime()} ou {@code null}
   *         caso no tenha sido executado.
   */
  public Long getStartTime();

  /**
   * Obtm o horrio de trmino da execuo do comando.
   * 
   * @return o horrio no padro {@link Date#getTime()} ou {@code null}
   *         caso no tenha sido executado.
   */
  public Long getEndTime();

  /**
   * Obtm o tempo de parede do comando.
   * 
   * @return o tempo em segundos ou {@code null} caso no tenha sido
   *         medido.
   */
  public Integer getElapsedTimeSec();

  /**
   * Obtm o tempo em modo usurio do comando.
   * 
   * @return o tempo em segundos ou {@code null} caso no tenha sido
   *         medido.
   */
  public Integer getUserTimeSec();

  /**
   * Obtm o tempo de sistema do comando.
   * 
   * @return o tempo em segundos ou {@code null} caso no tenha sido
   *         medido.
   */
  public Integer getCPUTimeSec();

  /**
   * Obtm o nome do servidor de execuo (SGA) escalonado para o comando.
   * 
   * @return o nome do SGA.
   */
  public String getExecutionHost();

}
