package csdk.v2.api.filesystem.project;

/**
 * Observador de mudanas no projeto corrente.
 */
public interface IProjectObserver {

  /**
   * Tratamento do evento de abertura de um projeto.
   * 
   * @param projectId o identificador do projeto recm-aberto.
   */
  public void onProjectOpen(String projectId);

  /**
   * Tratamento do evento de fechamento de um projeto.
   * 
   * @param projectId o identificador do projeto recm-fechado.
   */
  public void onProjectClose(String projectId);

}
