package csdk.v2.helper.command.parameters;

/**
 * Conversor de valores do tipo arquivo.
 */
public class URLValueConverter implements ParameterValueConverter<URL> {

  /**
   * {@inheritDoc}
   */
  @Override
  public String getValueAsString(URL value)
    throws ParameterValueConvertionException {
    if (value.getPath() == null) {
      return null;
    }
    StringBuffer valueAsText = new StringBuffer();
    valueAsText.append(value.getPath());
    valueAsText.append(":");
    valueAsText.append(value.getType());
    String protocol = value.getProtocol();
    if (protocol != null) {
      valueAsText.append(":");
      valueAsText.append(protocol);
    }
    String host = value.getHost();
    if (host != null) {
      valueAsText.append(":");
      valueAsText.append(host);
    }
    return valueAsText.toString();
  }

}

/**
 * Descrio do arquivo.
 */
class URL {

  /** Caminho do arquivo. */
  private final String path;
  /** Tipo do arquivo. */
  private final String type;
  /** Protocolo. */
  private final String protocol;
  /** O host. */
  private final String host;

  /**
   * Construtor.
   * 
   * @param path o caminho para o arquivo.
   * @param type o tipo do arquivo.
   * @param protocol o protocolo da URL.
   * @param host o host da URL.
   */
  public URL(String path, String type, String protocol, String host) {
    this.path = path;
    this.type = type;
    this.protocol = protocol;
    this.host = host;
  }

  /**
   * Construtor.
   * 
   * @param path o caminho para o arquivo.
   * @param type o tipo do arquivo.
   */
  public URL(String path, String type) {
    this(path, type, null, null);
  }

  /**
   * Obtm o caminho para o arquivo.
   * 
   * @return o caminho.
   */
  public String getPath() {
    return path;
  }

  /**
   * Obtm o tipo do arquivo.
   * 
   * @return o tipo.
   */
  public String getType() {
    return type;
  }

  /**
   * Obtm o protocolo da URL.
   * 
   * @return o protocolo.
   */
  public String getProtocol() {
    return protocol;
  }

  /**
   * Obtm o host da URL.
   * 
   * @return o host.
   */
  public String getHost() {
    return host;
  }
}
