/*
 * Decompiled with CFR 0.152.
 */
package csdk.v1_0.runner;

import csdk.v1_0.runner.ApplicationManager;
import csdk.v1_0.runner.ApplicationParameters;
import csdk.v1_0.runner.ApplicationRegistry;
import csdk.v1_0.runner.CSDKLogger;
import csdk.v1_0.runner.IContextFactory;
import csdk.v1_0.runner.RunnerException;
import csdk.v1_0.runner.application.RunnerApplication;
import csdk.v1_0.runner.filesystem.FileType;
import csdk.v1_0.runner.filesystem.FileTypes;
import csdk.v1_0.runner.filesystem.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.swing.SwingUtilities;

public class Runner {
    private String startingId;
    private static Locale locale = Locale.getDefault();
    private final Properties runnerProperties;
    private Charset charset = Charset.defaultCharset();

    private Runner() {
        this.runnerProperties = new Properties();
    }

    public static void main(String[] args) {
        final Runner runner = new Runner();
        runner.showHeader();
        if (runner.isOnlyHelp(args)) {
            runner.showHelp();
            runner.logFinish(true);
            return;
        }
        Runner.loadDefaultFileTypes();
        try {
            runner.checkArguments(args);
        }
        catch (RuntimeException e) {
            runner.logSevere("Command line parametrization error. Check arguments!", new Object[0]);
            runner.logException(e);
            runner.logFinish(false);
            return;
        }
        final ApplicationManager appManager = ApplicationManager.getInstance();
        Properties props = runner.getRunnerProperties();
        appManager.addContextProperties(props);
        String startId = runner.getStartingApplicationId();
        if (startId == null) {
            Set<String> appIds = appManager.getAllAplicationsIds();
            switch (appIds.size()) {
                case 0: {
                    runner.logSevere("No applications defined! Aborting...", new Object[0]);
                    runner.logFinish(false);
                    return;
                }
                case 1: {
                    startId = appIds.iterator().next();
                    break;
                }
                default: {
                    runner.logSevere("Multiple applications found and no starting application defined! Aborting...", new Object[0]);
                    runner.logFinish(false);
                    return;
                }
            }
        }
        final String appId = startId;
        ApplicationRegistry reg = runner.getApplicationRegistry(startId);
        if (reg == null) {
            runner.logSevere("Starting application not found! Aborting...", new Object[0]);
            runner.logFinish(false);
            return;
        }
        runner.log("Starting main application...", new Object[0]);
        runner.log("  * Application class name: {0}", reg.getClassName());
        runner.log("  * Application id: {0}", reg.getApplicationId());
        if (reg.hasNoProperty()) {
            runner.log("  * No property set for main application.", new Object[0]);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                appManager.finishAllApplications();
            }
        });
        runner.log("Starting main application...", new Object[0]);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    RunnerApplication startApp = appManager.runApplication(appId, runner.getCharset());
                    if (startApp == null) {
                        throw new RunnerException("Main application execution failed!", new Object[0]);
                    }
                    runner.logSevere("Main application started!", new Object[0]);
                }
            });
        }
        catch (Exception e) {
            runner.logException(e);
            runner.logFinish(false);
            return;
        }
        while (appManager.hasActiveApplications()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                runner.logException(e);
            }
        }
        runner.log("No more active applications", new Object[0]);
        runner.logFinish(true);
    }

    private void loadFileTypes(String path) {
        FileInputStream fileTypeDefinition;
        try {
            fileTypeDefinition = new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            throw new RunnerException(e, "File type list not found: {0}", path);
        }
        FileTypes.loadFileTypes(fileTypeDefinition);
    }

    private static void loadDefaultFileTypes() {
        InputStream defaultFileTypeDefinition = FileTypes.class.getResourceAsStream(FileTypes.class.getSimpleName() + ".properties");
        FileTypes.loadFileTypes(defaultFileTypeDefinition);
    }

    private Charset getCharset() {
        return this.charset;
    }

    private void buildNewApplicationRegistry(String id) {
        if (id != null) {
            String appId = id.trim();
            ApplicationManager applicationManager = ApplicationManager.getInstance();
            if (!applicationManager.hasApplicationRegistry(appId)) {
                ApplicationRegistry reg = new ApplicationRegistry(appId);
                applicationManager.addApplicationRegistry(reg);
            }
        }
    }

    private void checkArguments(String[] args) {
        int N = args.length;
        for (int i = 0; i < N; ++i) {
            String arg = args[i].trim();
            if (arg.equals("--locale")) {
                this.checkLocaleArgument(args[i + 1], args[i + 2]);
                i += 2;
                continue;
            }
            if (arg.equals("--verbose")) {
                this.setVerbosed(true);
                continue;
            }
            if (arg.equals("--charset")) {
                this.checkCharsetArgument(args[i + 1]);
                ++i;
                continue;
            }
            if (arg.equals("--file-types-property-file")) {
                this.loadFileTypes(args[i + 1]);
                ++i;
                continue;
            }
            if (arg.equals("--file-type")) {
                this.checkFileTypeArgument(args[i + 1], args[i + 2]);
                i += 2;
                continue;
            }
            if (arg.equals("--app-property")) {
                this.setApplicationProperty(args[i + 1], args[i + 2], args[i + 3]);
                i += 3;
                continue;
            }
            if (arg.equals("--runner-property")) {
                this.setRunnerProperty(args[i + 1], args[i + 2]);
                i += 2;
                continue;
            }
            if (arg.equals("--app-bundle")) {
                this.setBundleLoaded(args[i + 1], true);
                ++i;
                continue;
            }
            if (arg.equals("--app-singleton")) {
                this.setSingleton(args[i + 1], true);
                ++i;
                continue;
            }
            if (arg.equals("--app-require-project")) {
                this.setRequireProject(args[i + 1], true);
                ++i;
                continue;
            }
            if (arg.equals("--start-id")) {
                this.setStartingApplicationId(args[i + 1]);
                ++i;
                continue;
            }
            if (arg.equals("--context-factory")) {
                this.setContextFactory(args[i + 1]);
                ++i;
                continue;
            }
            if (arg.equals("--app-id")) {
                this.buildNewApplicationRegistry(args[i + 1]);
                ++i;
                continue;
            }
            if (arg.equals("--app-name")) {
                this.setApplicationName(args[i + 1], args[i + 2]);
                i += 2;
                continue;
            }
            if (arg.equals("--app-description")) {
                this.setDescription(args[i + 1], args[i + 2]);
                i += 2;
                continue;
            }
            if (arg.equals("--app-author")) {
                this.setAuthorName(args[i + 1], args[i + 2]);
                i += 2;
                continue;
            }
            if (arg.equals("--app-author-mail")) {
                this.setAuthorMail(args[i + 1], args[i + 2]);
                i += 2;
                continue;
            }
            if (arg.equals("--app-icon")) {
                this.setApplicationIcon(args[i + 1], args[i + 2]);
                i += 2;
                continue;
            }
            if (arg.equals("--app-small-icon")) {
                this.setSmallApplicationIcon(args[i + 1], args[i + 2]);
                i += 2;
                continue;
            }
            if (arg.equals("--app-package")) {
                this.loadApplicationFromPackage(args[i + 1], args[i + 2]);
                i += 2;
                continue;
            }
            if (arg.equals("--app-version")) {
                this.setApplicationVersion(args[i + 1], args[i + 2]);
                i += 2;
                continue;
            }
            if (arg.equals("--app-class")) {
                this.setClassName(args[i + 1], args[i + 2]);
                i += 2;
                continue;
            }
            if (arg.equals("--app-file-types")) {
                this.setApplicationFileTypes(args[i + 1], args[i + 2]);
                i += 2;
                continue;
            }
            if (arg.equals("--app-classpath")) {
                File baseDir = new File(".");
                this.setApplicationClasspath(args[i + 1], baseDir, args[i + 2]);
                i += 2;
                continue;
            }
            this.logSevere("Unrecognized argument found: {0}. Ignoring...", arg);
        }
    }

    private void setVerbosed(boolean verbosed) {
        CSDKLogger instance = CSDKLogger.getInstance();
        instance.setVerbosed(verbosed);
    }

    private void loadApplicationFromPackage(String id, String appPath) {
        if (id != null && appPath != null) {
            String appId = id.trim();
            String packagePath = appPath.trim();
            this.buildNewApplicationRegistry(appId);
            this.loadPropertiesFromPackage(appId, packagePath);
            this.loadIconsFromPackage(appId, packagePath);
        }
    }

    private void loadPropertiesFromPackage(String id, String appPath) {
        InputStreamReader reader = null;
        try {
            File path = new File(appPath);
            String propertyFileName = id + ".properties";
            File propertyFile = new File(path, propertyFileName);
            FileInputStream input = new FileInputStream(propertyFile);
            reader = new InputStreamReader((InputStream)input, this.charset);
            Properties props = new Properties();
            props.load(reader);
            for (ApplicationParameters param : ApplicationParameters.values()) {
                String key = param.getApplicationPropertyName(id);
                switch (param) {
                    case APP_NAME_PROPERTY: {
                        String localizedName = this.getLocalizedProperty(key, props);
                        this.setApplicationName(id, localizedName);
                        break;
                    }
                    case CLASS_NAME_PROPERTY: {
                        this.setClassName(id, (String)props.get(key));
                        break;
                    }
                    case FILE_TYPES_PROPERTY: {
                        this.setApplicationFileTypes(id, (String)props.get(key));
                        break;
                    }
                    case VERSION_PROPERTY: {
                        this.setApplicationVersion(id, (String)props.get(key));
                        break;
                    }
                    case AUTHOR_NAME_PROPERTY: {
                        this.setAuthorName(id, (String)props.get(key));
                        break;
                    }
                    case AUTHOR_MAIL_PROPERTY: {
                        this.setAuthorMail(id, (String)props.get(key));
                        break;
                    }
                    case DESCRIPTION_PROPERTY: {
                        String localizedDescription = this.getLocalizedProperty(key, props);
                        this.setDescription(id, localizedDescription);
                        break;
                    }
                    case NEED_BUNDLE_PROPERTY: {
                        String bundleValue = (String)props.get(key);
                        if (this.isNull(bundleValue)) break;
                        this.setBundleLoaded(id, Boolean.valueOf(bundleValue));
                        break;
                    }
                    case IS_SINGLETON_PROPERTY: {
                        String singletonValue = (String)props.get(key);
                        if (this.isNull(singletonValue)) break;
                        this.setSingleton(id, Boolean.valueOf(singletonValue));
                        break;
                    }
                    case REQUIRE_PROJECT_PROPERTY: {
                        String requireValue = (String)props.get(key);
                        if (this.isNull(requireValue)) break;
                        this.setRequireProject(id, Boolean.valueOf(requireValue));
                        break;
                    }
                    case CLASSPATH_PROPERTY: {
                        String[] classpath = this.getNumberedProperty(key, props);
                        if (classpath.length != 0) {
                            this.setApplicationClasspath(id, path, classpath);
                            break;
                        }
                        String classpathAsString = (String)props.get(key);
                        this.setApplicationClasspath(id, path, classpathAsString);
                    }
                }
                props.remove(key);
            }
            this.loadSpecificApplicationProperties(id, props);
        }
        catch (FileNotFoundException e) {
            String msg = "Application definition file in package ({0}) not found!";
            throw new RunnerException(e, msg, appPath);
        }
        catch (Exception e) {
            String msg = "Error reading application definition file in package ({0}).";
            throw new RunnerException(e, msg, appPath);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.logException(e);
                }
            }
        }
    }

    private String[] getNumberedProperty(String name, Properties props) {
        String propName;
        String value;
        LinkedList<String> list = new LinkedList<String>();
        int i = 1;
        while ((value = props.getProperty(propName = name + "." + i)) != null) {
            list.add(value);
            props.remove(propName);
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    private String getLocalizedProperty(String propName, Properties props) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String localizedPropName = propName + "." + language + "." + country;
        String value = props.getProperty(localizedPropName);
        props.remove(localizedPropName);
        return value;
    }

    private void loadSpecificApplicationProperties(String id, Properties props) {
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key;
            Object propertyValue;
            Object keyElement = keys.nextElement();
            if (keyElement == null || (propertyValue = props.get(key = (String)keyElement)) == null) continue;
            String value = (String)propertyValue;
            this.setApplicationProperty(id, key, value);
        }
    }

    private void loadIconsFromPackage(String id, String appPath) {
        String smallIconFileName;
        File smallIconFile;
        File path = new File(appPath);
        String iconFileName = id + ".32.gif";
        File iconFile = new File(path, iconFileName);
        if (iconFile.exists()) {
            this.setApplicationIcon(id, iconFile.getAbsolutePath());
        }
        if ((smallIconFile = new File(path, smallIconFileName = id + ".16.gif")).exists()) {
            this.setSmallApplicationIcon(id, smallIconFile.getAbsolutePath());
        }
    }

    private void setContextFactory(String factoryClassName) {
        if (factoryClassName != null) {
            String className = factoryClassName.trim();
            try {
                Class<?> factoryClass = Class.forName(className);
                if (!IContextFactory.class.isAssignableFrom(factoryClass)) {
                    String message = "Context factory class {0} must implement the inteface {1}";
                    String interfaceName = IContextFactory.class.getName();
                    throw new RunnerException(message, className, interfaceName);
                }
                IContextFactory contextFactory = (IContextFactory)factoryClass.newInstance();
                ApplicationManager appManager = ApplicationManager.getInstance();
                appManager.setContextFactory(contextFactory);
            }
            catch (ClassNotFoundException e) {
                String message = "Context factory class {0} not found in Runner classpath.";
                throw new RunnerException(e, message, className);
            }
            catch (InstantiationException e) {
                String message = "Context factory class {0} could not be instantiated. The class must have an public empty constructor and not be abstract.";
                throw new RunnerException(e, message, className);
            }
            catch (IllegalAccessException e) {
                String message = "Context factory class {0} could not be instantiated. The class must have an public empty constructor and not be abstract.";
                throw new RunnerException(e, message, className);
            }
        }
    }

    private void setApplicationFileTypes(String id, String fileTypesList) {
        if (this.checkApplicationRegistry(id) && !this.isNull(fileTypesList)) {
            String appId = id.trim();
            ApplicationRegistry reg = this.getApplicationRegistry(appId);
            String fileTypes = fileTypesList.trim();
            if (fileTypes != null) {
                String[] types;
                for (String type : types = fileTypes.split(",")) {
                    FileType fileType = FileTypes.getFileType(type);
                    if (fileType != null) continue;
                    String message = "Unknown file type {0} for application {1}.";
                    throw new RunnerException(message, type, appId);
                }
                reg.setFileTypes(types);
            }
        }
    }

    private void checkFileTypeArgument(String typeName, String extension) {
        FileType fileType;
        if (this.isNull(typeName) || this.isNull(extension)) {
            return;
        }
        String type = typeName.trim();
        String ext = extension.trim();
        if (FileTypes.hasFileType(type)) {
            fileType = FileTypes.getFileType(type);
        } else {
            this.log("Creating new file type: {0}...", type);
            fileType = FileTypes.createFileType(type);
        }
        this.log("Setting extension \"{0}\" to type: {1}...", ext, type);
        fileType.addExtension(ext);
    }

    private void checkCharsetArgument(String charset) {
        Charset runnerCharset;
        if (this.isNull(charset)) {
            return;
        }
        String charsetName = charset.trim();
        try {
            runnerCharset = Charset.forName(charsetName);
        }
        catch (Exception e) {
            throw new RunnerException(e, "Invalid charset: {0}", charsetName);
        }
        this.log("Setting charset to {0}...", charsetName);
        this.charset = runnerCharset;
    }

    private void checkLocaleArgument(String languageName, String countryName) {
        if (this.isNull(languageName) || this.isNull(countryName)) {
            return;
        }
        String lng = languageName.trim();
        String cty = countryName.trim();
        this.log("Setting locale to {0} ({1})...", lng, cty);
        locale = new Locale(lng, cty);
    }

    private void logFinish(boolean correctly) {
        String state = correctly ? "correctly" : "with errors";
        this.logSevere("Runner terminated {0}.", state);
        if (!correctly) {
            throw new RuntimeException();
        }
    }

    private String getStartingApplicationId() {
        return this.startingId;
    }

    private boolean isOnlyHelp(String[] args) {
        for (String arg : args) {
            if (!arg.equals("--help")) continue;
            return true;
        }
        return false;
    }

    private void log(String text, Object ... args) {
        CSDKLogger logger = CSDKLogger.getInstance();
        logger.log(text, args);
    }

    private void logException(Exception e) {
        CSDKLogger logger = CSDKLogger.getInstance();
        logger.logException(e);
    }

    private void logSevere(String text, Object ... args) {
        CSDKLogger logger = CSDKLogger.getInstance();
        logger.logSevere(text, args);
    }

    private void setApplicationClasspath(String id, File baseDir, String[] classpath) {
        if (this.checkApplicationRegistry(id) && classpath != null) {
            String appId = id.trim();
            ApplicationRegistry reg = this.getApplicationRegistry(appId);
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String path : classpath) {
                try {
                    String filePath = path.trim();
                    this.log("Classpath: {0} for application id: {1}", filePath, appId);
                    File element = FileUtils.isAbsolutePath(path) ? new File(filePath) : new File(baseDir, filePath);
                    if (!element.exists()) {
                        throw new RunnerException("Library: {0} not found!", path);
                    }
                    URL url = element.toURI().toURL();
                    urls.add(url);
                }
                catch (MalformedURLException e) {
                    String msg = "Invalid element in classpath: {0} for application id: {1}";
                    throw new RunnerException(e, msg, path, appId);
                }
            }
            reg.setClasspath(urls);
        }
    }

    private void setApplicationClasspath(String id, File baseDir, String classpath) {
        if (this.checkApplicationRegistry(id) && !this.isNull(classpath)) {
            String appId = id.trim();
            String cpath = classpath.trim();
            String[] paths = cpath.split(",");
            this.setApplicationClasspath(appId, baseDir, paths);
        }
    }

    private boolean checkApplicationRegistry(String id) {
        ApplicationManager appManager = ApplicationManager.getInstance();
        if (!appManager.hasApplicationRegistry(id)) {
            this.logSevere("Application id not registered: [{0}]", id);
            return false;
        }
        return true;
    }

    private ApplicationRegistry getApplicationRegistry(String id) {
        ApplicationManager appManager = ApplicationManager.getInstance();
        return appManager.getApplicationRegistry(id);
    }

    private void setApplicationIcon(String id, String applicationIconPath) {
        if (this.checkApplicationRegistry(id) && !this.isNull(applicationIconPath)) {
            String appId = id.trim();
            String appIcon = applicationIconPath.trim();
            ApplicationRegistry reg = this.getApplicationRegistry(appId);
            reg.setApplicationIconPath(appIcon);
        }
    }

    private void setApplicationVersion(String id, String version) {
        if (this.checkApplicationRegistry(id) && !this.isNull(version)) {
            String appId = id.trim();
            String appVersion = version.trim();
            ApplicationRegistry reg = this.getApplicationRegistry(appId);
            reg.setVersion(appVersion);
        }
    }

    private void setApplicationName(String id, String applicationName) {
        if (this.checkApplicationRegistry(id) && !this.isNull(applicationName)) {
            String appId = id.trim();
            String appName = applicationName.trim();
            ApplicationRegistry reg = this.getApplicationRegistry(appId);
            reg.setApplicationName(appName);
        }
    }

    private boolean isNull(String value) {
        return value == null || value.trim().equals("");
    }

    private void setDescription(String id, String description) {
        if (this.checkApplicationRegistry(id) && !this.isNull(description)) {
            String appId = id.trim();
            String appDescription = description.trim();
            ApplicationRegistry reg = this.getApplicationRegistry(appId);
            reg.setApplicationDescription(appDescription);
        }
    }

    private void setAuthorName(String id, String name) {
        if (this.checkApplicationRegistry(id) && !this.isNull(name)) {
            String appId = id.trim();
            String authorName = name.trim();
            ApplicationRegistry reg = this.getApplicationRegistry(appId);
            reg.setAuthor(authorName);
        }
    }

    private void setAuthorMail(String id, String mail) {
        if (this.checkApplicationRegistry(id) && !this.isNull(mail)) {
            String appId = id.trim();
            String authorMail = mail.trim();
            ApplicationRegistry reg = this.getApplicationRegistry(appId);
            reg.setAuthorEmail(authorMail);
        }
    }

    private void setBundleLoaded(String id, boolean bundleLoaded) {
        if (this.checkApplicationRegistry(id)) {
            String appId = id.trim();
            ApplicationRegistry reg = this.getApplicationRegistry(appId);
            reg.setBundleRequired(bundleLoaded);
        }
    }

    private void setSingleton(String id, boolean singleton) {
        if (this.checkApplicationRegistry(id)) {
            String appId = id.trim();
            ApplicationRegistry reg = this.getApplicationRegistry(appId);
            reg.setSingleton(singleton);
        }
    }

    private void setRequireProject(String id, boolean requireProject) {
        if (this.checkApplicationRegistry(id)) {
            String appId = id.trim();
            ApplicationRegistry reg = this.getApplicationRegistry(appId);
            reg.setRequiresProject(requireProject);
        }
    }

    private void setClassName(String id, String className) {
        if (this.checkApplicationRegistry(id) && !this.isNull(className)) {
            String appId = id.trim();
            String appClass = className.trim();
            ApplicationRegistry reg = this.getApplicationRegistry(appId);
            reg.setClassName(appClass);
        }
    }

    private void setApplicationProperty(String id, String key, String value) {
        if (this.checkApplicationRegistry(id)) {
            if (this.isNull(key)) {
                String err = "Empty key not allowed for property adjustment.";
                throw new IllegalArgumentException("Empty key not allowed for property adjustment.");
            }
            if (this.isNull(value)) {
                String err = "Empty value not allowed for property adjustment.";
                throw new IllegalArgumentException("Empty value not allowed for property adjustment.");
            }
            String appId = id.trim();
            String propKey = key.trim();
            if (!propKey.startsWith(appId + ".")) {
                String message = "Application property key must start with applicationId: {0}. Ignoring property {1}.";
                this.log(message, appId, propKey);
            }
            String propValue = value.trim();
            this.log("Setting application property: {0} = {1}", propKey, propValue);
            ApplicationRegistry reg = this.getApplicationRegistry(appId);
            reg.setProperty(propKey, propValue);
        }
    }

    private void setRunnerProperty(String key, String value) {
        if (this.isNull(key)) {
            String err = "Empty key not allowed for property adjustment.";
            throw new IllegalArgumentException("Empty key not allowed for property adjustment.");
        }
        if (this.isNull(value)) {
            String err = "Empty value not allowed for property adjustment.";
            throw new IllegalArgumentException("Empty value not allowed for property adjustment.");
        }
        String propKey = key.trim();
        String propValue = value.trim();
        this.log("Setting runner property: {0} = {1}", propKey, propValue);
        this.runnerProperties.setProperty(propKey, propValue);
    }

    private Properties getRunnerProperties() {
        return this.runnerProperties;
    }

    private void setSmallApplicationIcon(String id, String applicationIconPath) {
        if (this.checkApplicationRegistry(id) && !this.isNull(applicationIconPath)) {
            String appId = id.trim();
            String appIcon = applicationIconPath.trim();
            ApplicationRegistry reg = this.getApplicationRegistry(appId);
            reg.setSmallApplicationIconPath(appIcon);
        }
    }

    private void setStartingApplicationId(String id) {
        if (this.checkApplicationRegistry(id)) {
            this.startingId = id.trim();
        }
    }

    public static Locale getLocale() {
        return locale;
    }

    private void showHeader() {
        String lineSeparator = System.getProperty("line.separator");
        String bar = "=========================================================";
        StringBuilder builder = new StringBuilder();
        builder.append(lineSeparator);
        builder.append(bar);
        builder.append(lineSeparator);
        builder.append("CSDK/Runner - Executor for CSBASE Applications");
        builder.append(lineSeparator);
        builder.append("(C) 2013, Tecgraf/PUC-Rio");
        builder.append(lineSeparator);
        builder.append(bar);
        builder.append(lineSeparator);
        this.logSevere(builder.toString(), new Object[0]);
    }

    private void showHelp() {
        System.out.println(" Runner Parameters:");
        System.out.println("   --verbose");
        System.out.println("   --locale <language> <country>");
        System.out.println("   --file-type <type> <extension>");
        System.out.println("   --file-types-property-file <path>");
        System.out.println("   --context-factory <class>");
        System.out.println("   --runner-property <key> <value>");
        System.out.println("   --start-id <id>");
        System.out.println("   --charset <charset>");
        System.out.println("   --help");
        System.out.println("");
        System.out.println(" Application Parameters:");
        System.out.println(" >> If application is already packaged in a directory:");
        System.out.println("   --app-package <id> <path>");
        System.out.println(" >> Or define specific properties:");
        System.out.println("   --app-id <id>");
        System.out.println("   --app-bundle <id>");
        System.out.println("   --app-classpath <id> <classpath>");
        System.out.println("   --app-name <id> <application name>");
        System.out.println("   --app-description <id> <application description>");
        System.out.println("   --app-author <id> <author name>");
        System.out.println("   --app-author-mail <id> <author mail>");
        System.out.println("   --app-class <id> <class name>");
        System.out.println("   --app-property <id> <key> <value>");
        System.out.println("   --app-version <id> <version name>");
        System.out.println("   --app-singleton <id>");
        System.out.println("   --app-require-project <id>");
        System.out.println("   --app-icon <id> <image path>");
        System.out.println("   --app-file-types <id> <comma-separated type list>");
        System.out.println("   --app-small-icon <id> <image path>");
    }
}

