package snakegame.action;

import java.awt.event.ActionEvent;

import snakegame.SnakeGame;
import snakegame.session.Level;
import snakegame.session.Session;
import csdk.v2.helper.application.AbstractApplicationAction;

/**
 * Ao que modifica o nvel de dificuldade do jogo.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ChangeDifficultAction extends AbstractApplicationAction<SnakeGame> {

  /** Sesso. */
  private final Session session;

  /** Nvel de dificuldade. */
  private final Level level;

  /**
   * Construtor.
   * 
   * @param application aplicao.
   * @param session sesso.
   * @param level nvel de dificuldade.
   */
  public ChangeDifficultAction(SnakeGame application, Session session,
    Level level) {
    super(application);

    this.session = session;
    this.level = level;

    setName(getString(level.key));
  }

  /** {@inheritDoc} */
  @Override
  public void actionPerformed(ActionEvent event) {
    session.setLevel(level);
  }
}
