package textviewer.actions;

import java.awt.Window;

import javax.swing.Action;

import textviewer.TextViewer;
import textviewer.actions.core.OpenAction;
import csdk.v1_0.api.filesystem.IFile;
import csdk.v1_0.api.filesystem.FileSelectionType;
import csdk.v1_0.helper.application.ApplicationImages;

/**
 * Ao de abertura do arquivo
 * 
 * @author Tecgraf/PUC-Rio
 */
public class OpenLocalAction extends OpenAction {

  /**
   * {@inheritDoc}
   */
  @Override
  protected IFile selectFile() throws Exception {
    TextViewer textViewer = getApplication();
    String[] fileTypes = new String[] { "TEXT" };
    Window frm = textViewer.getApplicationFrame();

    IFile file =
      textViewer.browseLocalFileInOpenMode(fileTypes, false, null,
        FileSelectionType.FILES_ONLY, frm);
    if (file == null) {
      return null;
    }
    return file;
  }

  /**
   * Construtor
   * 
   * @param textViewer a aplicao.
   */
  public OpenLocalAction(TextViewer textViewer) {
    super(textViewer);
    putValue(Action.NAME, textViewer.getString("open.local.item"));
    putValue(Action.SMALL_ICON, ApplicationImages.ICON_OPEN_LOCAL_16);
  }
}
