/*
 * Decompiled with CFR 0.152.
 */
package csdk.v1_0.runner.user;

import csdk.v1_0.api.user.IUser;
import csdk.v1_0.api.user.IUserContext;
import csdk.v1_0.api.user.UserException;
import csdk.v1_0.runner.CSDKLogger;
import csdk.v1_0.runner.core.AbstractContext;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;

public class RunnerUserContext
extends AbstractContext
implements IUserContext {
    private final Map<String, IUser> users = new HashMap<String, IUser>();
    private IUser currentUser;

    public RunnerUserContext() {
    }

    public RunnerUserContext(Map<String, IUser> users) {
        this();
        this.users.putAll(users);
    }

    public RunnerUserContext(Map<String, IUser> users, String currentUser) throws UserException {
        this(users);
        this.currentUser = this.getUserByLogin(currentUser, null);
    }

    public final void contextActivated() {
        if (this.currentUser == null) {
            String login = System.getProperty("user.name");
            try {
                this.currentUser = this.getUserByLogin(login, null);
            }
            catch (UserException e) {
                CSDKLogger logger = CSDKLogger.getInstance();
                logger.logSevere("Current user not defined!", new Object[0]);
            }
        }
    }

    public IUser getCurrentUser() throws UserException {
        return this.currentUser;
    }

    public IUser[] getAllUsers(Window window) throws UserException {
        return this.users.values().toArray(new IUser[this.users.size()]);
    }

    public IUser getUserByLogin(String login, Window window) throws UserException {
        return this.users.get(login);
    }

    protected void contextDeactivated() {
        this.currentUser = null;
        this.users.clear();
    }
}

