/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.job.v1.impl;

import ibase.common.ServiceUtil;
import ibase.rest.api.authentication.v1.adapter.AuthenticationService;
import ibase.rest.api.authentication.v1.adapter.UnauthorizedException;
import ibase.rest.api.job.v1.adapter.JobMonitorListener;
import ibase.rest.api.job.v1.adapter.JobsServiceAdapter;
import ibase.rest.model.job.v1.InlineResponse200;
import ibase.rest.model.job.v1.Job;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.CompletionCallback;
import javax.ws.rs.container.ConnectionCallback;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ManagedAsync;

@Path(value="/jobs")
@Produces(value={"application/json;"})
@Singleton
@Api(description="the Jobs API")
public class JobsRealTimeApiService {
    private static final String OUT_LOG = "out.log";
    private static final Logger logger = Logger.getLogger(JobsRealTimeApiService.class.getName());
    private final long timeout = 50000L;

    @Path(value="/pull")
    @GET
    @ManagedAsync
    @ApiOperation(value="Monitor job execution.", notes="This endpoint makes a long polling request for get jobs information update after their submission. This operation returns if there is a jobstatus change, or when you get a timeout in the long polling request, or the connection drops.", response=InlineResponse200.class, tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation. The server lists the information aboutjobs modified after the date informed as query parameter.", response=InlineResponse200.class), @ApiResponse(code=401, message="Unauthorized request")})
    public void pull(final @Suspended AsyncResponse asyncResp, @ApiParam(value="Filter jobs associated with the project identified by projectId parameter.") @QueryParam(value="projectId") String projectId, @ApiParam(value="Filter the single job identified by jobId parameter.") @QueryParam(value="jobId") String jobId, final @ApiParam(value="Filter jobs modified after the date parameter.") @QueryParam(value="date") long date, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context ContainerRequest request, @Context AuthenticationService authenticationService, final @Context JobsServiceAdapter service) throws Exception {
        try {
            long callTime = System.currentTimeMillis();
            this.authenticate(request, authenticationService);
            asyncResp.setTimeout(50000L, TimeUnit.MILLISECONDS);
            final Predicate<Job> filterJob = j -> {
                if (j == null) {
                    return false;
                }
                if (jobId != null) {
                    return j.getJobId().equals(jobId);
                }
                if (projectId != null) {
                    return j.getProjectId().equals(projectId);
                }
                return true;
            };
            Collection<Job> jobs = service.getLastJobs(date, projectId, jobId);
            if (jobs != null && jobs.size() > 0) {
                this.resumeJobSuccess(asyncResp, jobs, callTime);
                return;
            }
            final JobMonitorListener listener = new JobMonitorListener(){

                @Override
                public void statusChanged(Job job) {
                    if (filterJob.test(job)) {
                        long newTime = 0L;
                        try {
                            Date newDate = JobsRealTimeApiService.this.parseDate(job.getLastModifiedTime());
                            newTime = newDate.getTime();
                        }
                        catch (Exception ignored) {
                            newTime = date;
                        }
                        JobsRealTimeApiService.this.resumeJobSuccess(asyncResp, Collections.singletonList(job), newTime);
                    }
                }

                @Override
                public void infoChanged(List<Job> jobs) {
                    if (jobs != null && jobs.size() > 0) {
                        ArrayList<Job> ret = new ArrayList<Job>();
                        long newTime = 0L;
                        for (Job job : jobs) {
                            block5: {
                                if (!filterJob.test(job)) continue;
                                try {
                                    Date newDate = JobsRealTimeApiService.this.parseDate(job.getLastModifiedTime());
                                    if (newDate.getTime() > newTime) {
                                        newTime = newDate.getTime();
                                    }
                                }
                                catch (Exception ignored) {
                                    if (newTime != 0L) break block5;
                                    newTime = date;
                                }
                            }
                            ret.add(job);
                        }
                        JobsRealTimeApiService.this.resumeJobSuccess(asyncResp, ret, newTime);
                    }
                }
            };
            asyncResp.register((Object)new CompletionCallback(){

                public void onComplete(Throwable throwable) {
                    service.removeJobMonitorListener(listener);
                }
            });
            asyncResp.register((Object)new ConnectionCallback(){

                public void onDisconnect(AsyncResponse disconnected) {
                    service.removeJobMonitorListener(listener);
                }
            });
            asyncResp.setTimeoutHandler(ar -> this.resumeJobSuccess(ar, null, date + 50000L));
            service.addJobMonitorListener(listener);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
            throw e;
        }
    }

    private void authenticate(ContainerRequest request, AuthenticationService authenticationService) throws ibase.rest.api.authentication.v1.adapter.ParseException, UnauthorizedException {
        authenticationService.parserToken(authenticationService.createToken(request.getProperty("userId").toString(), null, null), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Path(value="/pull/log")
    @GET
    @ManagedAsync
    @ApiOperation(value="Monitor job log output.", notes="This endpoint makes a long polling request for get the log output of a job execution. This operation returns if there is a joblog change, or when you get a timeout in the long polling request, or the connection drops.", response=InlineResponse200.class, tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation. The server returns the information aboutthe log modified.", response=InlineResponse200.class), @ApiResponse(code=401, message="Unauthorized request")})
    public void pullLog(@Suspended AsyncResponse asyncResp, @QueryParam(value="jobId") String jobId, @QueryParam(value="lastPosition") Long logPosParam, @QueryParam(value="fileId") String fileId, @Context ContainerRequest request, @Context AuthenticationService authenticationService, @Context JobsServiceAdapter service) throws ibase.rest.api.authentication.v1.adapter.ParseException, UnauthorizedException, IOException, InterruptedException {
        if (logPosParam == null) {
            logPosParam = 0L;
        }
        long logPosition = logPosParam;
        WatchService watchService = null;
        try {
            java.nio.file.Path pathToFile;
            this.authenticate(request, authenticationService);
            asyncResp.setTimeout(50000L, TimeUnit.MILLISECONDS);
            String logDirPath = service.getLogDir(jobId);
            if (logDirPath == null) {
                this.resumeLogSuccess(asyncResp, null, logPosition, jobId);
                return;
            }
            String fileName = fileId != null ? ServiceUtil.decodeFromBase64((String)fileId) : OUT_LOG;
            java.nio.file.Path logFilePath = Paths.get(logDirPath + File.separator + fileName, new String[0]);
            if (Files.exists(logFilePath, new LinkOption[0]) && Files.size(logFilePath) > logPosition) {
                StringBuilder builder = new StringBuilder();
                long returnedPosition = this.getPartialLog(logFilePath, logPosition, builder);
                if (returnedPosition <= 0L) return;
                this.resumeLogSuccess(asyncResp, builder.toString(), returnedPosition, jobId);
                return;
            }
            java.nio.file.Path path = Paths.get(logDirPath, new String[0]);
            FileSystem fileSystem = path.getFileSystem();
            WatchService finalWatchService = watchService = fileSystem.newWatchService();
            asyncResp.setTimeoutHandler(ar -> {
                try {
                    this.resumeLogSuccess(asyncResp, null, logPosition, jobId);
                    finalWatchService.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            path.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            boolean monitor = true;
            do {
                if (!monitor) return;
                WatchKey watchKey = watchService.take();
                pathToFile = null;
                for (WatchEvent<?> event : watchKey.pollEvents()) {
                    java.nio.file.Path changed = (java.nio.file.Path)event.context();
                    if (!changed.toString().endsWith(fileName)) continue;
                    pathToFile = changed;
                    break;
                }
                monitor = watchKey.reset();
            } while (pathToFile == null);
            StringBuilder builder = new StringBuilder();
            long returnedPosition = this.getPartialLog(logFilePath, logPosition, builder);
            if (returnedPosition <= 0L) return;
            this.resumeLogSuccess(asyncResp, builder.toString(), returnedPosition, jobId);
            return;
        }
        catch (ClosedWatchServiceException logDirPath) {
            return;
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Ocorreu uma excecao nao planejada.");
            logger.log(Level.SEVERE, "", e);
            this.resumeLogSuccess(asyncResp, null, logPosition, jobId);
            return;
        }
        finally {
            if (watchService != null) {
                try {
                    watchService.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getPartialLog(java.nio.file.Path logPath, Long logPos, StringBuilder contents) throws IOException {
        File logFile = logPath.toFile();
        if (!logFile.exists()) {
            return -1L;
        }
        try (RandomAccessFile r = new RandomAccessFile(logFile, "r");){
            r.seek(logPos);
            long pos = r.getFilePointer();
            long length = r.length();
            while (pos < length) {
                contents.append(r.readLine()).append("\n");
                pos = r.getFilePointer();
            }
            long l = pos;
            return l;
        }
    }

    private void resumeLogSuccess(AsyncResponse ar, String log, Long pos, String jobId) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (log != null) {
            m.put("log", log);
        }
        m.put("lastPosition", pos);
        m.put("jobId", jobId);
        ar.resume((Object)Response.status((Response.Status)Response.Status.OK).entity(m).build());
    }

    private void resumeJobSuccess(AsyncResponse ar, Collection<Job> jobs, long time) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (jobs != null) {
            m.put("jobs", jobs);
        }
        m.put("date", time);
        ar.resume((Object)Response.status((Response.Status)Response.Status.OK).entity(m).build());
    }

    private Date parseDate(String dateToParser) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        return format.parse(dateToParser);
    }
}

