/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.project.v1.impl;

import ibase.common.ServiceAdapter;
import ibase.common.ServiceUtil;
import ibase.rest.api.authentication.v1.adapter.AuthenticationService;
import ibase.rest.api.authentication.v1.adapter.ParseException;
import ibase.rest.api.project.v1.NotFoundException;
import ibase.rest.api.project.v1.impl.ProjectsApiServiceImpl;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/links")
@Produces(value={"application/json;"})
public class LinksApi {
    public static final String RESOURCE_BUNDLE = "properties.language.LinksApi";
    private static final Logger logger = Logger.getLogger("LinksApi");

    private ResourceBundle getBundle(String localeString) {
        Locale locale = ServiceUtil.getLocale((String)localeString);
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale, this.getClass().getClassLoader());
        return bundle;
    }

    @GET
    @Path(value="/download/{token}/{project_id}/{file_path}")
    @Produces(value={"application/octet-stream"})
    public Response linksTokenProjectIdFilesFilePathMetadataGet(@PathParam(value="project_id") String projectId, @PathParam(value="file_path") String filePath, @PathParam(value="token") String token, @QueryParam(value="locale") String locale, @QueryParam(value="compress") Boolean compress, @QueryParam(value="charset") String charset, @Context SecurityContext securityContext) throws NotFoundException {
        try {
            AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)locale);
            authenticationService.parserToken(token, null);
            ProjectsApiServiceImpl serviceImpl = new ProjectsApiServiceImpl();
            return serviceImpl.projectsProjectIdFilesFileIdGet(projectId, filePath, compress, charset, locale, securityContext);
        }
        catch (ParseException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("links.token.invalid", new String[0]));
        }
    }

    @GET
    @Path(value="/download_multiple")
    public Response linksProjectIdFilesGet(@QueryParam(value="locale") String locale, @QueryParam(value="token") String token, @Context SecurityContext securityContext) throws NotFoundException {
        if (token == null) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("links.token.invalid", new String[0]));
        }
        try {
            AuthenticationService authenticationService = (AuthenticationService)ServiceAdapter.getInstance(AuthenticationService.class, (String)locale);
            HashMap tokenParams = new HashMap();
            authenticationService.parserToken(token, tokenParams);
            ArrayList<String> files = new ArrayList<String>();
            String zipName = (String)tokenParams.get("zipName");
            String filesId = this.uncompressString((String)tokenParams.get("fileId"));
            String projectId = (String)tokenParams.get("projectId");
            for (String fileId : filesId.split(",")) {
                files.add(fileId);
            }
            ProjectsApiServiceImpl serviceImpl = new ProjectsApiServiceImpl();
            return serviceImpl.projectsProjectIdFilesGet(files, projectId, zipName, locale, securityContext);
        }
        catch (ParseException e) {
            return ServiceUtil.buildException((Response.Status)Response.Status.BAD_REQUEST, (Logger)logger, (String)ServiceUtil.getTranslator((ResourceBundle)this.getBundle(locale)).message("links.token.invalid", new String[0]));
        }
    }

    public String uncompressString(String zippedBase64Str) {
        byte[] bytes = Base64.getDecoder().decode(zippedBase64Str);
        try {
            GZIPInputStream zi = new GZIPInputStream(new ByteArrayInputStream(bytes));
            String result = new BufferedReader(new InputStreamReader(zi)).lines().collect(Collectors.joining("\n"));
            zi.close();
            return result;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

