/*
 * Decompiled with CFR 0.152.
 */
package ibase.rest.api.user.v1;

import ibase.rest.api.user.v1.NotFoundException;
import ibase.rest.api.user.v1.UsersApiService;
import ibase.rest.api.user.v1.factories.UsersApiServiceFactory;
import ibase.rest.model.user.v1.User;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="/users")
@Consumes(value={"application/x-www-form-urlencoded", "multipart/form-data"})
@Produces(value={"application/json;"})
@Api(description="the users API")
public class UsersApi {
    private final UsersApiService delegate = UsersApiServiceFactory.getUsersApi();

    @GET
    @Consumes(value={"application/x-www-form-urlencoded", "multipart/form-data"})
    @Produces(value={"application/json;"})
    @ApiOperation(value="Return the list of all registered users.", notes="This endpoint return a list of *CSGrid* Users. You can use filters to limit your result.", response=User.class, responseContainer="List", tags={"Users"})
    @ApiResponses(value={@ApiResponse(code=200, message="Request was successful.", response=User.class, responseContainer="List")})
    public Response usersGet(@ApiParam(value="Filter the users that contains this value in the name or login") @QueryParam(value="filter") String filter, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.usersGet(filter, locale, securityContext);
    }

    @GET
    @Path(value="/{userId}")
    @Consumes(value={"application/x-www-form-urlencoded", "multipart/form-data"})
    @Produces(value={"application/json;"})
    @ApiOperation(value="Find an user by his ID.", notes="Return the user that is identified by the userId.", response=User.class, tags={"Users"})
    @ApiResponses(value={@ApiResponse(code=200, message="Request was successul.", response=User.class), @ApiResponse(code=400, message="User was not found", response=User.class)})
    public Response usersUserIdGet(@ApiParam(value="The ID of an user.", required=true) @PathParam(value="userId") String userId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.usersUserIdGet(userId, locale, securityContext);
    }

    @GET
    @Path(value="/{userId}/photo")
    @Consumes(value={"application/x-www-form-urlencoded", "multipart/form-data"})
    @Produces(value={"image/gif"})
    @ApiOperation(value="Get the user photo image", notes="Return the binary content of the photo image for the specified user.", response=File.class, tags={"Users"})
    @ApiResponses(value={@ApiResponse(code=200, message="Request was successful and the binary content of the photo image was returned", response=File.class), @ApiResponse(code=400, message="Specified user ID is missing or malformed", response=File.class), @ApiResponse(code=404, message="Photo image for the specified user was not found", response=File.class), @ApiResponse(code=500, message="Processing error occurred accessing the photo image", response=File.class)})
    public Response usersUserIdPhotoGet(@ApiParam(value="The ID of an user.", required=true) @PathParam(value="userId") String userId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.usersUserIdPhotoGet(userId, locale, securityContext);
    }

    @PUT
    @Path(value="/{userId}/photo")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json;"})
    @ApiOperation(value="Change the user photo", notes="Change the user's photo. Users can only change their own photo. The administrator can change the photo of any user.", response=void.class, tags={"Users"})
    @ApiResponses(value={@ApiResponse(code=204, message="The photo image was succesfully updated", response=void.class), @ApiResponse(code=400, message="The specified user ID is missing or malformed", response=void.class), @ApiResponse(code=403, message="The authenticated user is not authorized to change the photo.", response=void.class), @ApiResponse(code=404, message="The specified user was not found", response=void.class), @ApiResponse(code=500, message="Processing error occurred updating the photo image", response=void.class)})
    public Response usersUserIdPhotoPut(@ApiParam(value="The ID of an user.", required=true) @PathParam(value="userId") String userId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @FormDataParam(value="upfile") InputStream upfileInputStream, @FormDataParam(value="upfile") FormDataContentDisposition upfileDetail, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.usersUserIdPhotoPut(userId, locale, upfileInputStream, upfileDetail, securityContext);
    }

    @PUT
    @Path(value="/{userId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json;"})
    @ApiOperation(value="Update the user profile information.", notes="Replace the name and/or emails of the user. Users can only change their own profile. The administrator can change the profile of any user. Return the user with the profile updated.", response=void.class, tags={"Users"})
    @ApiResponses(value={@ApiResponse(code=200, message="The information was updated.", response=void.class), @ApiResponse(code=400, message="The specified user ID is missing or malformed", response=void.class), @ApiResponse(code=403, message="The authenticated user is not authorized to change the photo.", response=void.class), @ApiResponse(code=404, message="The specified user was not found", response=void.class), @ApiResponse(code=500, message="Processing error occurred updating the photo image", response=void.class)})
    public Response usersUserIdPut(@ApiParam(value="The ID of an user.", required=true) @PathParam(value="userId") String userId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @ApiParam(value="The user's name.") @FormParam(value="name") String name, @ApiParam(value="The user's emails.") @FormParam(value="emails") List<String> emails, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.usersUserIdPut(userId, locale, name, emails, securityContext);
    }
}

