/*
 * Decompiled with CFR 0.152.
 */
package ibase.common.v2;

import ibase.common.v2.RestErrorMessage;
import io.jsonwebtoken.impl.Base64Codec;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;

public class ServiceUtil {
    public static Client getClient() {
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        try {
            sc.init(null, trustAllCerts, new SecureRandom());
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        Client client = ClientBuilder.newBuilder().sslContext(sc).hostnameVerifier(allHostsValid).build();
        return client;
    }

    public static Locale getLocale(String localeString) {
        Locale locale = null;
        if (localeString == null || localeString.isEmpty()) {
            locale = new Locale("en", "US");
            return locale;
        }
        switch (localeString) {
            case "pt_BR": {
                locale = new Locale("pt", "BR");
                break;
            }
            case "en_US": {
                locale = new Locale("en", "US");
                break;
            }
            default: {
                locale = new Locale("en", "US");
            }
        }
        return locale;
    }

    public static String encodeToBase64(String id) {
        if ("".equals(id)) {
            return "";
        }
        Base64Codec coded = new Base64Codec();
        return coded.encode(id);
    }

    public static String decodeFromBase64(String id) {
        if ("".equals(id)) {
            return "";
        }
        Base64Codec coded = new Base64Codec();
        return coded.decodeToString(id);
    }

    public static Translator getTranslator(ResourceBundle bundle) {
        return new Translator(bundle);
    }

    public static Response buildException(Response.Status status, Logger logger, String message) {
        logger.severe(message);
        return Response.status((Response.Status)status).entity((Object)new RestErrorMessage(message)).type("application/json;charset=utf-8").build();
    }

    public static Response buildExceptionWithoutMessage(Response.Status status, Logger logger, String message) {
        logger.severe(message);
        return Response.status((Response.Status)status).entity((Object)new RestErrorMessage()).type("application/json").build();
    }

    public static Response buildException(Response.Status status, Logger logger, Exception exception) {
        if (Response.Status.INTERNAL_SERVER_ERROR.equals((Object)status)) {
            logger.log(Level.SEVERE, "INTERNAL_SERVER_ERROR", exception);
        }
        return Response.status((Response.Status)status).entity((Object)new RestErrorMessage(exception.getMessage())).type("application/json").build();
    }

    public static class Translator {
        private ResourceBundle bundle;

        Translator(ResourceBundle bundle) {
            this.bundle = bundle;
        }

        public String message(String key, String ... args) {
            try {
                return MessageFormat.format(this.bundle.getString(key), args);
            }
            catch (MissingResourceException e) {
                return "<<" + key + ">>";
            }
        }
    }
}

