/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.concurrent.locks;

import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;

public class LockId
implements Serializable {
    private static final int ID_SIZE = 10;
    private byte[] value = new byte[10];
    private int hashCode;
    private static final String PRNG_ALGORITHM = "SHA1PRNG";

    public boolean equals(Object id) {
        if (id instanceof LockId) {
            LockId anotherId = (LockId)id;
            return Arrays.equals(this.value, anotherId.value);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int generateHashCode() {
        int hashCode = 1;
        for (int i = 0; i < 10; ++i) {
            hashCode = 31 * hashCode + Byte.valueOf(this.value[i]).hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            str.append(this.value[i]);
        }
        str.append('\n');
        return str.toString();
    }

    public LockId() {
        SecureRandom secureRandom = null;
        try {
            secureRandom = SecureRandom.getInstance(PRNG_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            secureRandom = new SecureRandom();
        }
        secureRandom.nextBytes(this.value);
        this.hashCode = this.generateHashCode();
    }
}

