/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.concurrent.locks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import tecgraf.javautils.concurrent.locks.Lock;
import tecgraf.javautils.concurrent.locks.LockId;
import tecgraf.javautils.concurrent.locks.LockLogger;
import tecgraf.javautils.concurrent.locks.LockPolicy;
import tecgraf.javautils.concurrent.locks.SharedAccessObject;

class LockInfo {
    SharedAccessObject lockedObject;
    private boolean allowsReentrance;
    private HashMap<LockPolicy, Vector<Lock>> lockMap;
    private HashMap<LockId, Lock> lockIdMap;
    private LockLogger logger;

    LockInfo(SharedAccessObject object, boolean allowsReentrance) {
        this.lockedObject = object;
        this.allowsReentrance = allowsReentrance;
        this.lockMap = new HashMap();
        this.lockIdMap = new HashMap();
        this.logger = LockLogger.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Lock> getLocks() {
        HashMap<LockPolicy, Vector<Lock>> hashMap = this.lockMap;
        synchronized (hashMap) {
            LockPolicy[] policies = this.lockMap.keySet().toArray(new LockPolicy[0]);
            return new ArrayList<Lock>(this.getLocks((LockId)null, policies));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Lock> getLocks(LockId originatorLockId) {
        HashMap<LockPolicy, Vector<Lock>> hashMap = this.lockMap;
        synchronized (hashMap) {
            LockPolicy[] policies = this.lockMap.keySet().toArray(new LockPolicy[0]);
            return new ArrayList<Lock>(this.getLocks(originatorLockId, policies));
        }
    }

    Set<Lock> getLocks(LockPolicy ... policies) {
        return this.getLocks((LockId)null, policies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Lock> getLocks(LockId originatorLockId, LockPolicy ... policies) {
        HashSet<Lock> locks = new HashSet<Lock>();
        if (policies != null) {
            for (LockPolicy policy : policies) {
                HashMap<LockPolicy, Vector<Lock>> hashMap = this.lockMap;
                synchronized (hashMap) {
                    Vector<Lock> locksList = this.lockMap.get((Object)policy);
                    if (locksList != null) {
                        for (Lock lock : locksList) {
                            if (originatorLockId != null) {
                                if (lock.getOriginatorLockId().equals(originatorLockId)) continue;
                                locks.add(lock);
                                continue;
                            }
                            locks.add(lock);
                        }
                    }
                }
            }
        }
        return locks;
    }

    Set<Lock> getLocks(Object ownerKey, LockPolicy ... policies) {
        HashSet<Lock> locks = new HashSet<Lock>();
        for (Lock lock : this.getLocks(policies)) {
            Object lockOwner = lock.getOwnerKey();
            if (lockOwner == null || !lockOwner.equals(ownerKey)) continue;
            locks.add(lock);
        }
        return locks;
    }

    boolean hasLock(LockPolicy policy, Object ownerKey) {
        LockPolicy lockPolicy = this.getLockPolicy(ownerKey);
        if (lockPolicy == null) {
            return false;
        }
        return policy.getValue() <= lockPolicy.getValue();
    }

    LockPolicy getLockPolicy(Object ownerKey) {
        LockPolicy policy = null;
        for (Lock lock : this.getLocks()) {
            Object lockOwner = lock.getOwnerKey();
            if (lockOwner == null || !lockOwner.equals(ownerKey) || policy != null && lock.getPolicy().getValue() <= policy.getValue()) continue;
            policy = lock.getPolicy();
        }
        return policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<LockPolicy, Set<Object>> getLockOwners() {
        LockPolicy[] policies;
        HashMap<LockPolicy, Vector<Lock>> hashMap = this.lockMap;
        synchronized (hashMap) {
            policies = this.lockMap.keySet().toArray(new LockPolicy[0]);
        }
        return this.getLockOwners(policies);
    }

    Map<LockPolicy, Set<Object>> getLockOwners(LockPolicy ... policies) {
        HashMap<LockPolicy, Set<Object>> mapPolicyOwners = new HashMap<LockPolicy, Set<Object>>();
        if (policies != null) {
            for (LockPolicy policy : policies) {
                HashSet<Object> ownersByPolicy = new HashSet<Object>();
                for (Lock lock : this.getLocks(policy)) {
                    Object lockOwner = lock.getOwnerKey();
                    if (lockOwner == null) continue;
                    ownersByPolicy.add(lockOwner);
                }
                mapPolicyOwners.put(policy, ownersByPolicy);
            }
        }
        return mapPolicyOwners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Lock newLock(LockPolicy lockPolicy, Object ownerKey, LockId originatorLockId) {
        Lock theLock = new Lock(lockPolicy, ownerKey, originatorLockId);
        HashMap<Object, Object> hashMap = this.lockMap;
        synchronized (hashMap) {
            Vector<Lock> locks = this.lockMap.get((Object)lockPolicy);
            if (locks == null) {
                locks = new Vector();
            }
            this.lockMap.put(lockPolicy, locks);
            locks.add(theLock);
        }
        hashMap = this.lockIdMap;
        synchronized (hashMap) {
            this.lockIdMap.put(theLock.getId(), theLock);
        }
        return theLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Lock removeLock(LockId lockId) {
        Lock lock;
        HashMap<Object, Object> hashMap = this.lockIdMap;
        synchronized (hashMap) {
            lock = this.lockIdMap.get(lockId);
        }
        if (lock == null) {
            this.logger.fine("Lock n\u00e3o existe no mapeamento entre ids e locks");
            return null;
        }
        hashMap = this.lockMap;
        synchronized (hashMap) {
            List locksByPolicy = this.lockMap.get((Object)lock.getPolicy());
            if (locksByPolicy != null && locksByPolicy.remove(lock)) {
                if (locksByPolicy.size() <= 0) {
                    this.lockMap.remove((Object)lock.getPolicy());
                }
                HashMap<LockId, Lock> hashMap2 = this.lockIdMap;
                synchronized (hashMap2) {
                    this.lockIdMap.remove(lockId);
                }
                return lock;
            }
        }
        this.logger.fine("Lock n\u00e3o existe no mapeamento por pol\u00edticas");
        return null;
    }

    boolean allowsReentrance() {
        return this.allowsReentrance;
    }
}

