package tecgraf.javautils.excel.v1;

import java.awt.Component;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/**
 * Classe que configura o Excel com as propriedades do Sistema
 * 
 * @author Tecgraf
 */
public class ExcelConfig {

  /** Locale */
  private static Locale locale;
  /** Exportadores */
  private static Map<Class<?>, ExcelExportableAdapter> exportables =
    new HashMap<Class<?>, ExcelExportableAdapter>();

  /**
   * Altera o Locale
   * 
   * @param locale
   */
  public static void setLocale(Locale locale) {
    ExcelConfig.locale = locale;
  }

  /**
   * @return locale
   */
  public static Locale getLocale() {
    if (locale == null) {
      locale = Locale.getDefault();
    }
    return locale;
  }

  /**
   * Adiciona um exportador de um componente.
   * 
   * @param componentClass
   * @param adapter
   */
  public static void setExportable(Class<?> componentClass,
    ExcelExportableAdapter adapter) {
    if (adapter instanceof ExcelExportable) {
      throw new IllegalArgumentException();
    }
    exportables.put(componentClass, adapter);
  }

  /**
   * Retorna o adaptador de exportao mais prximo na hierarquia de classe.
   * 
   * @param component
   * @return adaptador de exportao
   */
  public static ExcelExportableAdapter getExportable(Component component) {
    return exportables.get(component.getClass());
  }

}
