package tecgraf.javautils.excel.v1;

/**
 * Interface que armazena o intervalo do merge de uma celula
 * 
 * 
 * @author bbreder
 */
public interface ExcelMerge {

  /**
   * Retorna o valor inicial da coluna
   * 
   * @return valor inicial da coluna (1..Short.MAX_VALUE)
   */
  public int getColumnBeginIndex();

  /**
   * Retorna o valor final da coluna
   * 
   * @return valor inicial da coluna (1..Short.MAX_VALUE)
   */
  public int getColumnEndIndex();

  /**
   * Retorna o valor inicial da linha
   * 
   * @return valor inicial da coluna (1..Short.MAX_VALUE)
   */
  public int getRowBeginIndex();

  /**
   * Retorna o valor final da linha
   * 
   * @return valor inicial da coluna (1..Short.MAX_VALUE)
   */
  public int getRowEndIndex();

}
