package tecgraf.javautils.excel.v1;

/**
 * Interface responsvel pela formatao das celulas de uma planilha.
 * 
 * 
 * @author bbreder
 */
public interface ExcelStyleTool extends ExcelTool {

  /**
   * Cria um estilo novo e retorna para ser personalizado. O reuso de estilo 
   * uma boa prtica de uso dessa ferramenta.
   * 
   * @return estilo novo criado para ser personalizado
   */
  public ExcelStyle createStyle();

  /**
   * Atribui um estilo para uma celula.
   * 
   * @param column coluna (1..Short.MAX_VALUE)
   * @param row linha (1..Short.MAX_VALUE)
   * @param style estilo a ser atribuido
   * @return a prpria estrutura
   */
  public ExcelStyleTool setStyle(int column, int row, ExcelStyle style);

  /**
   * Atribui um estilo para um intervalo de celulas.
   * 
   * @param column coluna (1..Short.MAX_VALUE)
   * @param rowBegin inicio de linha (1..Short.MAX_VALUE) inclusive
   * @param rowEnd fim de linha (1..Short.MAX_VALUE) inclusive
   * @param style estilo a ser atribuido
   * @return a prpria estrutura
   */
  public ExcelStyleTool setStyleRow(int column, int rowBegin, int rowEnd,
    ExcelStyle style);

  /**
   * Atribui um estilo para um intervalo de celulas.
   * 
   * @param columnBegin inicio de coluna (1..Short.MAX_VALUE) inclusive
   * @param columnEnd fim de coluna (1..Short.MAX_VALUE) inclusive
   * @param row linha (1..Short.MAX_VALUE)
   * @param style estilo a ser atribuido
   * @return a prpria estrutura
   */
  public ExcelStyleTool setStyleColumn(int columnBegin, int columnEnd, int row,
    ExcelStyle style);

  /**
   * Atribui um estilo para um intervalo de celulas.
   * 
   * @param columnBegin inicio de coluna (1..Short.MAX_VALUE) inclusive
   * @param columnEnd fim de coluna (1..Short.MAX_VALUE) inclusive
   * @param rowBegin inicio de linha (1..Short.MAX_VALUE) inclusive
   * @param rowEnd fim de linha (1..Short.MAX_VALUE) inclusive
   * @param style estilo a ser atribuido
   * @return a prpria estrutura
   */
  public ExcelStyleTool setStyle(int columnBegin, int columnEnd, int rowBegin,
    int rowEnd, ExcelStyle style);

  /**
   * Aplica uma borda em forma de caixa com uma espessura especifica
   * 
   * @param column coluna (1..Short.MAX_VALUE)
   * @param row linha (1..Short.MAX_VALUE)
   * @param stroke espessura da linha
   * @param color cor da linha
   * @return prpria estrutura
   */
  public ExcelStyleTool addBox(int column, int row, ExcelStroke stroke,
    ExcelColor color);

  /**
   * Aplica uma borda em forma de caixa com uma espessura especifica
   * 
   * @param column coluna (1..Short.MAX_VALUE)
   * @param rowBegin inicio de linha (1..Short.MAX_VALUE) inclusive
   * @param rowEnd fim de linha (1..Short.MAX_VALUE) inclusive
   * @param stroke espessura da linha
   * @param color cor da linha
   * @return prpria estrutura
   */
  public ExcelStyleTool addBoxRow(int column, int rowBegin, int rowEnd,
    ExcelStroke stroke, ExcelColor color);

  /**
   * Aplica uma borda em forma de caixa com uma espessura especifica
   * 
   * @param columnBegin inicio da coluna (1..Short.MAX_VALUE) inclusive
   * @param columnEnd fim da coluna (1..Short.MAX_VALUE) inclusive
   * @param row linha (1..Short.MAX_VALUE)
   * @param stroke espessura da linha
   * @param color cor da linha
   * @return prpria estrutura
   */
  public ExcelStyleTool addBoxColumn(int columnBegin, int columnEnd, int row,
    ExcelStroke stroke, ExcelColor color);

  /**
   * Aplica uma borda em forma de caixa com uma espessura especifica
   * 
   * @param columnBegin inicio da coluna (1..Short.MAX_VALUE) inclusive
   * @param columnEnd fim da coluna (1..Short.MAX_VALUE) inclusive
   * @param rowBegin inicio da linha (1..Short.MAX_VALUE) inclusive
   * @param rowEnd fim da linha (1..Short.MAX_VALUE) inclusive
   * @param stroke espessura da linha
   * @param color cor da linha
   * @return prpria estrutura
   */
  public ExcelStyleTool addBox(int columnBegin, int columnEnd, int rowBegin,
    int rowEnd, ExcelStroke stroke, ExcelColor color);

  /**
   * Retorna um estilo j utilizado atravs de uma chave. Esse mtodo  usado
   * para se fazer cache de um estilo.
   * 
   * @param key chave do estilo
   * @return estilo j utilizado
   */
  public ExcelStyle getStyle(String key);

  /**
   * Atribui um estilo j utilizado atravs de uma chave
   * 
   * @param key chave do estilo
   * @param style estilo a ser atribuido
   */
  public void setStyle(String key, ExcelStyle style);

}
