package tecgraf.javautils.excel.v1.poi;

import java.io.IOException;
import java.io.OutputStream;

import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

import tecgraf.javautils.excel.v1.Excel;
import tecgraf.javautils.excel.v1.ExcelFactory;
import tecgraf.javautils.excel.v1.ExcelModel;

/**
 * Classe responsvel por facilitar a construo de uma planilha excel. A classe
 * trabalho em funo dos modelo atribuido a ela. Para cada modelo, ser criado
 * um sheet correspondente.
 * 
 * 
 * @author bbreder
 */
public class PoiExcel implements Excel {

  /** Planilha Excel */
  private HSSFWorkbook workbook;
  /** Modelos para os sheets */
  private ExcelModel[] models;
  /** Fabrica de Objetos */
  private ExcelFactory factory;

  /**
   * Construtor padro
   * 
   * @param models modelos para gerar os sheets
   */
  public PoiExcel(ExcelModel... models) {
    this.factory = PoiExcelFactory.getInstance();
    this.models = models;
  }

  /**
   * Operao que ir construir a planilha excel atravs dos modelos atribuido
   * no construtor
   * 
   * @param output
   * @throws IOException
   */
  public void save(OutputStream output) throws IOException {
    this.workbook = new HSSFWorkbook();
    PoiExcelSheet sheetHelper = new PoiExcelSheet(this);
    for (ExcelModel model : this.models) {
      String sheetname = model.getSheetName();
      HSSFSheet sheet = workbook.createSheet(sheetname);
      sheetHelper.build(model, workbook, sheet);
    }
    workbook.write(output);
    output.close();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ExcelModel[] getModels() {
    return models;
  }

  /**
   * Retorna a planilha excel
   * 
   * @return planilha excel
   */
  protected HSSFWorkbook getWorkbook() {
    return workbook;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getAdapter() {
    return this.getWorkbook();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ExcelFactory getFactory() {
    return this.factory;
  }

}
