/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.excel.v1.util;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import tecgraf.javautils.excel.v1.AbstractExcelModel;
import tecgraf.javautils.excel.v1.ExcelColor;
import tecgraf.javautils.excel.v1.ExcelDataTool;
import tecgraf.javautils.excel.v1.ExcelModel;
import tecgraf.javautils.excel.v1.ExcelStroke;
import tecgraf.javautils.excel.v1.ExcelStructureTool;
import tecgraf.javautils.excel.v1.ExcelStyleTool;
import tecgraf.javautils.excel.v1.poi.PoiExcel;
import tecgraf.javautils.excel.v1.poi.PoiExcelFactory;

public abstract class ExcelAction
extends AbstractAction {
    public Component owner;

    public ExcelAction(Component owner, String title) {
        super("Name");
        this.putValue("Name", title);
        this.owner = owner;
    }

    public abstract ExcelModel[] getModels();

    @Override
    public void actionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        XLSFilter ff = new XLSFilter();
        jfc.setFileFilter(ff);
        jfc.setFileSelectionMode(0);
        String filename = this.getExportFileName();
        jfc.setSelectedFile(new File(StringUtils.fixName(filename) + ".xls"));
        if (jfc.showSaveDialog(this.owner) == 0) {
            String filePath = jfc.getSelectedFile().getPath();
            final PoiExcel excel = PoiExcelFactory.getInstance().buildExcel(this.getModels());
            final File file = this.createFileForWrite(this.owner, filePath);
            if (file != null) {
                new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        try {
                            ExcelAction.this.export(excel, file);
                            ExcelAction.this.runLaterInEDT(new Runnable(){

                                @Override
                                public void run() {
                                    ExcelAction.this.openInEDT(file);
                                }
                            });
                        }
                        catch (Throwable e) {
                            ExcelAction.this.runLaterInEDT(new Runnable(){

                                @Override
                                public void run() {
                                    ExcelAction.this.handler(e);
                                }
                            });
                        }
                        return null;
                    }
                }.run();
            }
        }
    }

    protected void handler(Throwable e) {
        e.printStackTrace();
    }

    protected void openInEDT(File file) {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().open(file);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void export(PoiExcel excel, File file) throws IOException {
        boolean error = false;
        FileOutputStream output = new FileOutputStream(file);
        try {
            excel.save(output);
        }
        catch (IOException e) {
            error = true;
            throw e;
        }
        catch (Exception e) {
            error = true;
            throw new RuntimeException(e);
        }
        finally {
            output.close();
            if (error) {
                file.delete();
            }
        }
    }

    protected File createFileForWrite(Component owner, String filePath) {
        if (filePath.endsWith(".xls")) {
            filePath = filePath.substring(0, filePath.length() - 4);
        }
        File originalFile = new File(filePath);
        String name = StringUtils.removeAccents(originalFile.getName()).replaceAll("[^-\\w. ]", "_") + ".xls";
        originalFile = new File(originalFile.getParent(), name);
        filePath = originalFile.getAbsolutePath();
        if (!originalFile.exists()) {
            return originalFile;
        }
        File file = originalFile;
        int n = 1;
        while (file.exists()) {
            filePath = filePath.replaceAll("[\\$[0-9]]*.xls", "");
            filePath = filePath + "$" + n++ + ".xls";
            file = new File(filePath);
        }
        Object[] options = new Object[]{this.getYesTitle(), this.getNoTitle()};
        int ans = JOptionPane.showOptionDialog(owner, this.getFileExistsMessage(originalFile, file), this.getFileExistsTitle(), 0, 3, null, options, options[0]);
        if (ans == 1) {
            return null;
        }
        return file;
    }

    protected String getExportFileName() {
        return "noname";
    }

    protected String getFileExistsTitle() {
        return "Arquivo j\u00e1 existe";
    }

    protected String getFileExistsMessage(File originalFile, File file) {
        return MessageFormat.format("Esta pasta j\u00e1 cont\u00e9m um arquivo com o nome {0}.\nSer\u00e1 criado um arquivo com o nome {1}.\nConfirma?", originalFile.getName(), file.getName());
    }

    protected String getYesTitle() {
        return "Sim";
    }

    protected String getNoTitle() {
        return "N\u00e3o";
    }

    protected void runLaterInEDT(Runnable r) {
        SwingUtilities.invokeLater(r);
    }

    public static void main(String[] args) {
        new ExcelAction(null, ""){

            @Override
            public ExcelModel[] getModels() {
                return new ExcelModel[]{new AbstractExcelModel(){

                    @Override
                    public void build(ExcelStructureTool head, ExcelDataTool data, ExcelStyleTool style) {
                        style.setStyle(1, 2, style.createStyle().center().bold());
                        style.addBox(1, 1, 1, 1, ExcelStroke.SIMPLE_THIN, ExcelColor.BROWN);
                        data.setCell(1, 1, "A1");
                        style.addBox(1, 1, 2, 2, ExcelStroke.MEDIUM, ExcelColor.RED);
                        data.setCell(1, 2, "B1");
                        style.addBox(1, 1, 3, 3, ExcelStroke.DOUBLE_THIN, ExcelColor.GREEN);
                        data.setCell(1, 3, "C1");
                    }
                }};
            }
        }.actionPerformed(null);
    }

    public static class XLSFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            String filename = file.getName();
            if (file.isDirectory()) {
                return true;
            }
            return filename.endsWith(".xls");
        }

        @Override
        public String getDescription() {
            return "*.xls";
        }
    }

    public static class StringUtils {
        private static Map<Character, Character> ACCENT_REMOVAL_MAP = new HashMap<Character, Character>();

        public static String fixName(String str) {
            String string = str;
            string = string.replace('\\', ' ');
            string = string.replace('[', ' ');
            string = string.replace(']', ' ');
            string = string.replace('>', ' ');
            string = string.replace('<', ' ');
            string = string.replace('*', ' ');
            string = string.replace('?', ' ');
            string = string.replace(':', ' ');
            string = string.replace('/', ' ');
            return string.substring(0, Math.min(string.length(), 29));
        }

        public static String removeAccents(String str) {
            char[] cStr = str.toCharArray();
            for (int i = 0; i < cStr.length; ++i) {
                Character c = ACCENT_REMOVAL_MAP.get(Character.valueOf(cStr[i]));
                if (c == null) continue;
                cStr[i] = c.charValue();
            }
            return new String(cStr);
        }

        static {
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00e1'), Character.valueOf('a'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00e0'), Character.valueOf('a'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00e3'), Character.valueOf('a'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00e2'), Character.valueOf('a'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00c1'), Character.valueOf('A'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00c0'), Character.valueOf('A'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00c3'), Character.valueOf('A'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00c2'), Character.valueOf('A'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00e9'), Character.valueOf('e'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00e8'), Character.valueOf('e'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00ea'), Character.valueOf('e'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00c9'), Character.valueOf('E'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00c8'), Character.valueOf('E'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00ca'), Character.valueOf('E'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00ed'), Character.valueOf('i'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00ec'), Character.valueOf('i'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00cd'), Character.valueOf('i'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00cc'), Character.valueOf('i'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00f3'), Character.valueOf('o'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00f2'), Character.valueOf('o'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00f5'), Character.valueOf('o'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00f4'), Character.valueOf('o'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00d3'), Character.valueOf('O'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00d2'), Character.valueOf('O'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00d5'), Character.valueOf('O'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00d4'), Character.valueOf('O'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00fa'), Character.valueOf('u'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00f9'), Character.valueOf('u'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00da'), Character.valueOf('u'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00d9'), Character.valueOf('u'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00e7'), Character.valueOf('c'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00c7'), Character.valueOf('C'));
        }
    }
}

