package tecgraf.javautils.excel.v1;

/**
 * Classe responsvel por inicializar objetos de uma tecnologia de exportao
 * 
 * 
 * @author bbreder
 */
public interface ExcelFactory {

  /**
   * Constroi uma Arquivo Excel
   * 
   * @param models
   * @return excel
   */
  public Excel buildExcel(ExcelModel... models);

  /**
   * Constroi uma Arquivo Excel
   * 
   * @param adapter
   * @return excel
   */
  public ExcelSheet buildExcelSheet(Excel adapter);

  /**
   * Constroi o facilitador de contedo
   * 
   * @param adapter
   * @return objeto construido
   */
  public ExcelDataTool buildExcelData(ExcelSheet adapter);

  /**
   * Constroi o facilitador de contedo
   * 
   * @param adapter
   * @return objeto construido
   */
  public ExcelStructureTool buildExcelHeadFormat(ExcelSheet adapter);

  /**
   * Constroi um estilo
   * 
   * @param adapter
   * @return estilo
   */
  public ExcelStyle buildExcelStyle(Excel adapter);

}
