package tecgraf.javautils.excel.v1.util;

import tecgraf.javautils.excel.v1.ExcelDataTool;
import tecgraf.javautils.excel.v1.ExcelStructureTool;
import tecgraf.javautils.excel.v1.ExcelStyleTool;

/**
 * Item abstrato
 * 
 * 
 * @author bbreder
 */
public abstract class AbstractItem {

  /** Quantas linhas ocupa esse item */
  private int rowHeight;

  /**
   * Implementa a gerao do relatorio. Esse mtodo ser executado duas vezes
   * para ser enviado para o arquivo excel. Na primeira vez, o argumento testign
   * ser atribuida como true e na segunda vez ser false.
   * 
   * @param head
   * @param data
   * @param style
   * @param testing
   */
  public abstract void build(ExcelStructureTool head, ExcelDataTool data,
    ExcelStyleTool style, boolean testing);

  /**
   * Retorna a altura em nmero de linhas usadas no componente
   * 
   * @return altura em linhas
   */
  public int getRowHeight() {
    return rowHeight;
  }

  /**
   * Altera a altura em nmero de linhas usadas no componente
   * 
   * @param rowHeight altura em linhas
   */
  public void setRowHeight(int rowHeight) {
    this.rowHeight = rowHeight;
  }

}