package tecgraf.javautils.excel.v1.util;

import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;

import tecgraf.javautils.excel.v1.ExcelStyle;
import tecgraf.javautils.excel.v1.ExcelStyleTool;
import tecgraf.javautils.excel.v1.ExcelTable;

/**
 * Implementao padro do ExcelTable
 * 
 * 
 * @author Bernardo Breder
 */
public class DefaultExcelTable implements ExcelTable {

 /**
   * @param c
   * @return valor primitivo do componente
   */
  @Override
  public Object getCorner(Component c) {
    if (c instanceof JTextComponent) {
      return ((JTextComponent) c).getText();
    }
    else if (c instanceof JLabel) {
      return ((JLabel) c).getText();
    }
    else {
      return "";
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumn(Object columnValue, int columnIndex) {
    return columnValue == null ? "" : columnValue.toString();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(JTable table, int row, int column, Object valueAt) {
    return valueAt;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ExcelStyle getStyle(JTable table, int row, int column,
    ExcelStyleTool style) {
    return null;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getColumnHeaderValue(JTable table, int column, Object valueAt) {
    return valueAt;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ExcelStyle getColumnHeaderStyle(JTable table, int column,
    ExcelStyleTool style) {
    return null;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getRowHeaderValue(JTable table, Component rowComponent,
    int row, Object struct) {
    return struct;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ExcelStyle getRowHeaderStyle(JTable table, Component rowComponent,
    int row, ExcelStyleTool style) {
    return null;
  }

}
