/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.excel.v1.poi;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import tecgraf.javautils.excel.v1.ExcelModel;
import tecgraf.javautils.excel.v1.ExcelSheet;
import tecgraf.javautils.excel.v1.poi.PoiExcel;
import tecgraf.javautils.excel.v1.poi.PoiExcelDataTool;
import tecgraf.javautils.excel.v1.poi.PoiExcelStructureTool;
import tecgraf.javautils.excel.v1.poi.PoiExcelStyleTool;

public class PoiExcelSheet
implements ExcelSheet {
    private final PoiExcel helper;
    private HSSFSheet sheet;
    private ExcelModel model;

    public PoiExcelSheet(PoiExcel helper) {
        this.helper = helper;
    }

    public void build(ExcelModel model, HSSFWorkbook workbook, HSSFSheet sheet) {
        this.model = model;
        this.sheet = sheet;
        PoiExcelStructureTool head = new PoiExcelStructureTool(this);
        head.setSheet(sheet);
        PoiExcelDataTool data = new PoiExcelDataTool(this);
        data.setSheet(sheet);
        PoiExcelStyleTool style = new PoiExcelStyleTool(this);
        head.setSheet(sheet);
        this.model.build(head, data, style);
    }

    protected HSSFCell getCellMerged(int column, int row) {
        HSSFCell poiCell;
        HSSFRow poiRow;
        int rowIndex = row - 1;
        short colIndex = (short)(column - 1);
        for (int n = 0; n < this.sheet.getNumMergedRegions(); ++n) {
            Region region = this.sheet.getMergedRegionAt(n);
            if (!region.contains(rowIndex, colIndex)) continue;
            rowIndex = region.getRowFrom();
            colIndex = region.getColumnFrom();
            break;
        }
        if ((poiRow = this.sheet.getRow(rowIndex)) == null) {
            poiRow = this.sheet.createRow(rowIndex);
        }
        if ((poiCell = poiRow.getCell(colIndex)) == null) {
            poiCell = poiRow.createCell(colIndex);
        }
        return poiCell;
    }

    protected HSSFCell getCell(int column, int row) {
        HSSFCell poiCell;
        int rowIndex = row - 1;
        short colIndex = (short)(column - 1);
        HSSFRow poiRow = this.sheet.getRow(rowIndex);
        if (poiRow == null) {
            poiRow = this.sheet.createRow(rowIndex);
        }
        if ((poiCell = poiRow.getCell(colIndex)) == null) {
            poiCell = poiRow.createCell(colIndex);
        }
        return poiCell;
    }

    @Override
    public PoiExcel getExcel() {
        return this.helper;
    }

    @Override
    public ExcelModel getModel() {
        return this.model;
    }

    public HSSFSheet getPoiSheet() {
        return this.sheet;
    }
}

