/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.excel.v1.poi;

import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import tecgraf.javautils.excel.v1.ExcelColor;
import tecgraf.javautils.excel.v1.ExcelStroke;
import tecgraf.javautils.excel.v1.ExcelStyle;
import tecgraf.javautils.excel.v1.poi.PoiExcelColor;
import tecgraf.javautils.excel.v1.poi.PoiExcelStroke;

public class PoiExcelStyle
implements ExcelStyle,
Cloneable {
    private HSSFWorkbook workbook;
    private HSSFCellStyle style;
    private HSSFFont font;
    private Short align;
    private boolean bold;
    private boolean italic;
    private boolean strikeout;
    private Short forecolor;
    private Short backcolor;
    private Short size;
    private ExcelStroke borderTopStroke;
    private ExcelStroke borderBottomStroke;
    private ExcelStroke borderLeftStroke;
    private ExcelStroke borderRightStroke;
    private ExcelColor borderTopColor;
    private ExcelColor borderBottomColor;
    private ExcelColor borderLeftColor;
    private ExcelColor borderRightColor;
    private Object adapter;

    public PoiExcelStyle(HSSFWorkbook workbook) {
        this.workbook = workbook;
    }

    @Override
    public ExcelStyle left() {
        this.align = 1;
        return this;
    }

    @Override
    public ExcelStyle center() {
        this.align = 2;
        return this;
    }

    @Override
    public ExcelStyle right() {
        this.align = 3;
        return this;
    }

    @Override
    public PoiExcelStyle bold() {
        this.bold = true;
        return this;
    }

    @Override
    public PoiExcelStyle italic() {
        this.italic = true;
        return this;
    }

    @Override
    public PoiExcelStyle strikeout() {
        this.strikeout = true;
        return this;
    }

    @Override
    public PoiExcelStyle forecolor(ExcelColor color) {
        short scolor = PoiExcelColor.get(color);
        this.forecolor = scolor;
        return this;
    }

    @Override
    public PoiExcelStyle backcolor(ExcelColor color) {
        short scolor = PoiExcelColor.get(color);
        this.backcolor = scolor;
        return this;
    }

    @Override
    public PoiExcelStyle size(int height) {
        short sheight = (short)Math.min(Short.MAX_VALUE, height);
        this.size = sheight;
        return this;
    }

    @Override
    public ExcelStyle borderTop(ExcelStroke stroke, ExcelColor color) {
        this.borderTopStroke = stroke;
        this.borderTopColor = color;
        return this;
    }

    @Override
    public ExcelStyle borderBottom(ExcelStroke stroke, ExcelColor color) {
        this.borderBottomStroke = stroke;
        this.borderBottomColor = color;
        return this;
    }

    @Override
    public ExcelStyle borderLeft(ExcelStroke stroke, ExcelColor color) {
        this.borderLeftStroke = stroke;
        this.borderLeftColor = color;
        return this;
    }

    @Override
    public ExcelStyle borderRight(ExcelStroke stroke, ExcelColor color) {
        this.borderRightStroke = stroke;
        this.borderRightColor = color;
        return this;
    }

    protected HSSFCellStyle getStyle() {
        if (this.style == null) {
            this.style = this.getWorkbook().createCellStyle();
        }
        return this.style;
    }

    protected HSSFFont getFont() {
        if (this.font == null) {
            this.font = this.getWorkbook().createFont();
            this.getStyle().setFont(this.font);
        }
        return this.font;
    }

    public Object buildAdapter() {
        HSSFCellStyle style = this.getStyle();
        HSSFFont font = this.getFont();
        style.setVerticalAlignment((short)1);
        if (this.align != null) {
            style.setAlignment(this.align.shortValue());
        }
        if (this.bold) {
            font.setBoldweight((short)700);
        }
        if (this.italic) {
            font.setItalic(true);
        }
        if (this.strikeout) {
            font.setStrikeout(true);
        }
        if (this.forecolor != null) {
            font.setColor(this.forecolor.shortValue());
            style.setFillForegroundColor(this.forecolor.shortValue());
        }
        if (this.backcolor != null) {
            style.setFillForegroundColor(this.backcolor.shortValue());
            style.setFillPattern((short)1);
        }
        if (this.size != null) {
            font.setFontHeight((short)Math.min(this.size * 20, Short.MAX_VALUE));
        }
        if (this.borderTopStroke != null) {
            style.setBorderTop(PoiExcelStroke.get(this.borderTopStroke));
            style.setTopBorderColor(PoiExcelColor.get(this.borderTopColor));
        }
        if (this.borderBottomStroke != null) {
            style.setBorderBottom(PoiExcelStroke.get(this.borderBottomStroke));
            style.setBottomBorderColor(PoiExcelColor.get(this.borderBottomColor));
        }
        if (this.borderLeftStroke != null) {
            style.setBorderLeft(PoiExcelStroke.get(this.borderLeftStroke));
            style.setLeftBorderColor(PoiExcelColor.get(this.borderLeftColor));
        }
        if (this.borderRightStroke != null) {
            style.setBorderRight(PoiExcelStroke.get(this.borderRightStroke));
            style.setRightBorderColor(PoiExcelColor.get(this.borderRightColor));
        }
        this.adapter = style;
        return style;
    }

    protected HSSFWorkbook getWorkbook() {
        return this.workbook;
    }

    @Override
    public Object getAdapter() {
        if (this.adapter == null) {
            this.adapter = this.buildAdapter();
        }
        return this.adapter;
    }

    public PoiExcelStyle clone() {
        try {
            PoiExcelStyle clone = (PoiExcelStyle)super.clone();
            clone.style = null;
            clone.font = null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.align == null ? 0 : this.align.hashCode());
        result = 31 * result + (this.backcolor == null ? 0 : this.backcolor.hashCode());
        result = 31 * result + (this.bold ? 1231 : 1237);
        result = 31 * result + (this.borderBottomColor == null ? 0 : this.borderBottomColor.hashCode());
        result = 31 * result + (this.borderBottomStroke == null ? 0 : this.borderBottomStroke.hashCode());
        result = 31 * result + (this.borderLeftColor == null ? 0 : this.borderLeftColor.hashCode());
        result = 31 * result + (this.borderLeftStroke == null ? 0 : this.borderLeftStroke.hashCode());
        result = 31 * result + (this.borderRightColor == null ? 0 : this.borderRightColor.hashCode());
        result = 31 * result + (this.borderRightStroke == null ? 0 : this.borderRightStroke.hashCode());
        result = 31 * result + (this.borderTopColor == null ? 0 : this.borderTopColor.hashCode());
        result = 31 * result + (this.borderTopStroke == null ? 0 : this.borderTopStroke.hashCode());
        result = 31 * result + (this.forecolor == null ? 0 : this.forecolor.hashCode());
        result = 31 * result + (this.italic ? 1231 : 1237);
        result = 31 * result + (this.size == null ? 0 : this.size.hashCode());
        result = 31 * result + (this.strikeout ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PoiExcelStyle other = (PoiExcelStyle)obj;
        if (this.align == null ? other.align != null : !this.align.equals(other.align)) {
            return false;
        }
        if (this.backcolor == null ? other.backcolor != null : !this.backcolor.equals(other.backcolor)) {
            return false;
        }
        if (this.bold != other.bold) {
            return false;
        }
        if (this.borderBottomColor != other.borderBottomColor) {
            return false;
        }
        if (this.borderBottomStroke != other.borderBottomStroke) {
            return false;
        }
        if (this.borderLeftColor != other.borderLeftColor) {
            return false;
        }
        if (this.borderLeftStroke != other.borderLeftStroke) {
            return false;
        }
        if (this.borderRightColor != other.borderRightColor) {
            return false;
        }
        if (this.borderRightStroke != other.borderRightStroke) {
            return false;
        }
        if (this.borderTopColor != other.borderTopColor) {
            return false;
        }
        if (this.borderTopStroke != other.borderTopStroke) {
            return false;
        }
        if (this.forecolor == null ? other.forecolor != null : !this.forecolor.equals(other.forecolor)) {
            return false;
        }
        if (this.italic != other.italic) {
            return false;
        }
        if (this.size == null ? other.size != null : !this.size.equals(other.size)) {
            return false;
        }
        return this.strikeout == other.strikeout;
    }

    public String toString() {
        return "PoiExcelStyle [align=" + this.align + ", bold=" + this.bold + ", italic=" + this.italic + ", strikeout=" + this.strikeout + ", forecolor=" + this.forecolor + ", backcolor=" + this.backcolor + ", size=" + this.size + ", borderTopStroke=" + (Object)((Object)this.borderTopStroke) + ", borderBottomStroke=" + (Object)((Object)this.borderBottomStroke) + ", borderLeftStroke=" + (Object)((Object)this.borderLeftStroke) + ", borderRightStroke=" + (Object)((Object)this.borderRightStroke) + ", borderTopColor=" + (Object)((Object)this.borderTopColor) + ", borderBottomColor=" + (Object)((Object)this.borderBottomColor) + ", borderLeftColor=" + (Object)((Object)this.borderLeftColor) + ", borderRightColor=" + (Object)((Object)this.borderRightColor) + "]";
    }
}

