/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.excel.v1.util;

import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import tecgraf.javautils.excel.v1.ExcelModel;
import tecgraf.javautils.excel.v1.poi.PoiExcel;

public abstract class ExcelAction
extends AbstractAction {
    public Component owner;

    public ExcelAction(Component owner, String title) {
        super("Name");
        this.putValue("Name", title);
        this.owner = owner;
    }

    public abstract ExcelModel[] getModels();

    protected void handler(Throwable e) {
        e.printStackTrace();
    }

    protected void openInEDT(File file) throws IOException {
        if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().open(file);
        }
    }

    protected void export(PoiExcel excel, File file) throws IOException {
        try (FileOutputStream output = new FileOutputStream(file);){
            excel.save(output);
        }
        catch (IOException e) {
            file.delete();
            throw e;
        }
        catch (Throwable e) {
            file.delete();
            throw new RuntimeException(e);
        }
    }

    protected File createFileForWrite(Component owner, String filePath) {
        if (filePath.endsWith(".xls")) {
            filePath = filePath.substring(0, filePath.length() - 4);
        }
        File originalFile = new File(filePath);
        String name = StringUtils.removeAccents(originalFile.getName()).replaceAll("[^-\\w. ]", "_") + ".xls";
        originalFile = new File(originalFile.getParent(), name);
        filePath = originalFile.getAbsolutePath();
        if (!originalFile.exists()) {
            return originalFile;
        }
        File file = originalFile;
        int n = 1;
        while (file.exists()) {
            filePath = filePath.replaceAll("[\\$[0-9]]*.xls", "");
            filePath = filePath + "$" + n++ + ".xls";
            file = new File(filePath);
        }
        Object[] options = new Object[]{this.getYesTitle(), this.getNoTitle()};
        int ans = JOptionPane.showOptionDialog(owner, this.getFileExistsMessage(originalFile, file), this.getFileExistsTitle(), 0, 3, null, options, options[0]);
        if (ans == 1) {
            return null;
        }
        return file;
    }

    protected String getExportFileName() {
        return "noname";
    }

    protected String getFileExistsTitle() {
        return "Arquivo j\u00e1 existe";
    }

    protected String getFileExistsMessage(File originalFile, File file) {
        return MessageFormat.format("Esta pasta j\u00e1 cont\u00e9m um arquivo com o nome {0}.\nSer\u00e1 criado um arquivo com o nome {1}.\nConfirma?", originalFile.getName(), file.getName());
    }

    protected String getYesTitle() {
        return "Sim";
    }

    protected String getNoTitle() {
        return "N\u00e3o";
    }

    protected void runLaterInEDT(Runnable r) {
        SwingUtilities.invokeLater(r);
    }

    public static class XLSFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            String filename = file.getName();
            if (file.isDirectory()) {
                return true;
            }
            return filename.endsWith(".xls");
        }

        @Override
        public String getDescription() {
            return "*.xls";
        }
    }

    public static class StringUtils {
        private static Map<Character, Character> ACCENT_REMOVAL_MAP = new HashMap<Character, Character>();

        public static String fixName(String str) {
            String string = str;
            string = string.replace('\\', ' ');
            string = string.replace('[', ' ');
            string = string.replace(']', ' ');
            string = string.replace('>', ' ');
            string = string.replace('<', ' ');
            string = string.replace('*', ' ');
            string = string.replace('?', ' ');
            string = string.replace(':', ' ');
            string = string.replace('/', ' ');
            while (string.indexOf("  ") >= 0) {
                string = string.replace("  ", " ");
            }
            return string.substring(0, Math.min(string.length(), 29));
        }

        public static String removeAccents(String str) {
            char[] cStr = str.toCharArray();
            for (int i = 0; i < cStr.length; ++i) {
                Character c = ACCENT_REMOVAL_MAP.get(Character.valueOf(cStr[i]));
                if (c == null) continue;
                cStr[i] = c.charValue();
            }
            return new String(cStr);
        }

        static {
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00e1'), Character.valueOf('a'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00e0'), Character.valueOf('a'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00e3'), Character.valueOf('a'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00e2'), Character.valueOf('a'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00c1'), Character.valueOf('A'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00c0'), Character.valueOf('A'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00c3'), Character.valueOf('A'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00c2'), Character.valueOf('A'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00e9'), Character.valueOf('e'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00e8'), Character.valueOf('e'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00ea'), Character.valueOf('e'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00c9'), Character.valueOf('E'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00c8'), Character.valueOf('E'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00ca'), Character.valueOf('E'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00ed'), Character.valueOf('i'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00ec'), Character.valueOf('i'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00cd'), Character.valueOf('i'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00cc'), Character.valueOf('i'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00f3'), Character.valueOf('o'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00f2'), Character.valueOf('o'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00f5'), Character.valueOf('o'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00f4'), Character.valueOf('o'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00d3'), Character.valueOf('O'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00d2'), Character.valueOf('O'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00d5'), Character.valueOf('O'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00d4'), Character.valueOf('O'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00fa'), Character.valueOf('u'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00f9'), Character.valueOf('u'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00da'), Character.valueOf('u'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00d9'), Character.valueOf('u'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00e7'), Character.valueOf('c'));
            ACCENT_REMOVAL_MAP.put(Character.valueOf('\u00c7'), Character.valueOf('C'));
        }
    }
}

