/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.excel.v1.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JTable;
import tecgraf.javautils.excel.v1.AbstractExcelModel;
import tecgraf.javautils.excel.v1.ExcelColor;
import tecgraf.javautils.excel.v1.ExcelDataTool;
import tecgraf.javautils.excel.v1.ExcelExportable;
import tecgraf.javautils.excel.v1.ExcelMerge;
import tecgraf.javautils.excel.v1.ExcelStroke;
import tecgraf.javautils.excel.v1.ExcelStructureTool;
import tecgraf.javautils.excel.v1.ExcelStyleTool;
import tecgraf.javautils.excel.v1.ExcelTable;
import tecgraf.javautils.excel.v1.poi.PoiExcel;
import tecgraf.javautils.excel.v1.style.DefaultExcelStyleSet;
import tecgraf.javautils.excel.v1.util.AbstractItem;
import tecgraf.javautils.excel.v1.util.DefaultExcelTable;
import tecgraf.javautils.excel.v1.util.ExcelTableUtil;

public abstract class VerticalExcelModel
extends AbstractExcelModel {
    private List<AbstractItem> list = new ArrayList<AbstractItem>();
    private int precision = 1;

    public abstract void preBuild();

    @Override
    public void build(ExcelStructureTool head, ExcelDataTool data, ExcelStyleTool style) {
        ExcelMerge merge;
        int row;
        int row2;
        this.preBuild();
        data.setNumberPrecision(this.precision);
        for (int n = 0; n < 2; ++n) {
            data.setCell(1, 1);
            row2 = 1;
            for (AbstractItem item : this.list) {
                item.build(head, data, style, n == 0);
                item.setRowHeight(data.getRow() - row2);
                row2 = data.getRow();
            }
        }
        Integer index = null;
        row2 = 1;
        for (int n = 0; n < this.list.size(); ++n) {
            AbstractItem item;
            item = this.list.get(n);
            if (HeaderItem.class.isInstance(item) && index == null) {
                index = row2;
            }
            if (!HeaderItem.class.isInstance(item) && index != null) {
                int columnBegin = 1;
                int columnEnd = data.getMaxColumnUsed();
                int rowBegin = index;
                int rowEnd = row2 - item.getRowHeight();
                style.addBox(columnBegin, columnEnd, rowBegin, rowEnd, ExcelStroke.MEDIUM, ExcelColor.BLACK);
                index = null;
            }
            row2 += item.getRowHeight();
        }
        for (int col = 1; col <= data.getMaxColumnUsed(); ++col) {
            int width = 0;
            for (row = 1; row <= data.getMaxRowUsed(); ++row) {
                merge = head.hasMerge(col, row);
                if (merge != null) continue;
                width = Math.max(width, data.getCellWidth(col, row));
            }
            head.setColumnWidth(col, width);
        }
        HashSet<ExcelMerge> mergeUsedSet = new HashSet<ExcelMerge>();
        for (int col = 1; col <= data.getMaxColumnUsed(); ++col) {
            for (row = 1; row <= data.getMaxRowUsed(); ++row) {
                merge = head.hasMerge(col, row);
                if (merge == null || mergeUsedSet.contains(merge)) continue;
                mergeUsedSet.add(merge);
                int dataWidth = data.getCellWidth(col, row);
                int headWidth = 0;
                int beginColumn = merge.getColumnBeginIndex();
                int endColumn = merge.getColumnEndIndex();
                for (int n = beginColumn; n <= endColumn; ++n) {
                    headWidth += head.getColumnWidth(n);
                }
                int columns = endColumn - beginColumn;
                if (dataWidth <= headWidth) continue;
                int delta = (dataWidth - headWidth) / (columns + 1);
                for (int n = beginColumn; n <= endColumn; ++n) {
                    head.setColumnWidth(n, head.getColumnWidth(n) + delta);
                }
            }
        }
    }

    public void addHeader(String text) {
        this.list.add(new HeaderItem(text));
    }

    public void addTable(JTable table) {
        this.addTable(table, new DefaultExcelTable());
    }

    public void addTable(JTable table, ExcelTable format) {
        this.list.add(new TableItem(table, format, false));
    }

    public void addTable(JTable table, ExcelTable format, boolean firstIsRowHeader) {
        this.list.add(new TableItem(table, format, firstIsRowHeader));
    }

    public void addLine() {
        this.list.add(new LineItem());
    }

    public void addReserved() {
        this.list.add(new ReservedItem());
    }

    public void addItem(AbstractItem item) {
        this.list.add(item);
    }

    public void addExportable(ExcelExportable exportable, ExcelTable format) {
        this.list.add(new ExportableItem(exportable, format));
    }

    public void setPrecision(int value) {
        this.precision = value;
    }

    public static void main(String[] args) throws IOException {
        new PoiExcel(new VerticalExcelModel(){

            @Override
            public void preBuild() {
                this.addHeader("Linha 1");
                this.addHeader("Linha 2");
                this.addHeader("Linha 3");
                this.addLine();
                this.addTable(new JTable(5, 3));
                this.addLine();
                this.addTable(new JTable(10, 5));
                this.addLine();
                this.addReserved();
            }
        }).save(new FileOutputStream("test.xls"));
    }

    private class ExportableItem
    extends AbstractItem {
        private final ExcelExportable exportable;
        private final ExcelTable format;

        public ExportableItem(ExcelExportable exportable, ExcelTable format) {
            this.exportable = exportable;
            this.format = format;
        }

        @Override
        public void build(ExcelStructureTool head, ExcelDataTool data, ExcelStyleTool style, boolean testing) {
            this.exportable.exportExcel(head, data, style, this.format);
        }
    }

    private class ReservedItem
    extends AbstractItem {
        private ReservedItem() {
        }

        @Override
        public void build(ExcelStructureTool head, ExcelDataTool data, ExcelStyleTool style, boolean testing) {
            data.setCell(data.getColumn(), data.getRow(), "RESERVADA");
            if (!testing) {
                head.mergeColumn(1, data.getMaxColumnUsed(), data.getRow());
                style.setStyle(data.getColumn(), data.getRow(), DefaultExcelStyleSet.buildReserved(style));
            }
            data.incRow();
        }
    }

    private class TableItem
    extends AbstractItem {
        private JTable table;
        private ExcelTable format;
        private boolean firstIsRowHeader;

        public TableItem(JTable table, ExcelTable getValue, boolean firstIsRowHeader) {
            this.table = table;
            this.format = getValue;
            this.firstIsRowHeader = firstIsRowHeader;
        }

        @Override
        public void build(ExcelStructureTool head, ExcelDataTool data, ExcelStyleTool style, boolean testing) {
            ExcelTableUtil.setTable(head, data, style, data.getColumn(), data.getRow(), this.table, this.format, this.firstIsRowHeader);
        }
    }

    private class HeaderItem
    extends AbstractItem {
        private String text;

        public HeaderItem(String text) {
            this.text = text;
        }

        @Override
        public void build(ExcelStructureTool head, ExcelDataTool data, ExcelStyleTool style, boolean testing) {
            if (!testing) {
                head.mergeColumn(1, data.getMaxColumnUsed(), data.getRow());
                style.setStyleColumn(1, data.getMaxColumnUsed(), data.getRow(), DefaultExcelStyleSet.buildTopHeader(style));
            }
            data.setCellVertical(this.text);
        }
    }

    private class LineItem
    extends AbstractItem {
        private LineItem() {
        }

        @Override
        public void build(ExcelStructureTool head, ExcelDataTool data, ExcelStyleTool style, boolean testing) {
            data.incRow();
        }
    }
}

