/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.excel.v1.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlNode
implements Comparable<XmlNode> {
    private String name;
    private final TreeMap<String, String> attributes = new TreeMap();
    private final SortedSet<XmlNode> nodes = new TreeSet<XmlNode>();

    public XmlNode(String name) {
        this.name = name;
    }

    public XmlNode(InputStream input, boolean onlyHeader) throws ParseException, IOException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource source = new InputSource(input);
            source.setEncoding("utf-8");
            Document document = db.parse(source);
            if (document.getFirstChild() instanceof Element) {
                Element element = (Element)document.getFirstChild();
                this.read(element, onlyHeader);
            }
        }
        catch (ParserConfigurationException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        catch (SAXException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    private XmlNode(Element element) {
        this.read(element, false);
    }

    private void read(Element root, boolean onlyHeader) {
        block5: {
            Node node;
            int size;
            block6: {
                this.name = root.getNodeName();
                NamedNodeMap atts = root.getAttributes();
                if (atts != null) {
                    int size2 = atts.getLength();
                    for (int n = 0; n < size2; ++n) {
                        Node node2 = atts.item(n);
                        if (!(node2 instanceof Attr)) continue;
                        Attr attr = (Attr)node2;
                        this.attributes.put(attr.getName(), attr.getValue());
                    }
                }
                if (!onlyHeader) break block6;
                NodeList nodes = root.getChildNodes();
                if (nodes == null) break block5;
                size = nodes.getLength();
                for (int n = 0; n < size; ++n) {
                    Element element;
                    node = nodes.item(n);
                    if (!(node instanceof Element) || !(element = (Element)node).getTagName().equals("head")) continue;
                    XmlNode child = new XmlNode(element);
                    this.nodes.add(child);
                    break block5;
                }
                break block5;
            }
            NodeList nodes = root.getChildNodes();
            if (nodes != null) {
                size = nodes.getLength();
                for (int n = 0; n < size; ++n) {
                    node = nodes.item(n);
                    if (!(node instanceof Element)) continue;
                    Element element = (Element)node;
                    XmlNode child = new XmlNode(element);
                    this.nodes.add(child);
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean hasAttribute(String attribute) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.get(attribute) != null;
    }

    public String getAttribute(String attribute) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(attribute);
    }

    public Integer getAttribute(String attribute, Integer defaultValue) {
        if (this.attributes == null) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(this.attributes.get(attribute));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public String getAttribute(String attribute, String defaultValue) {
        if (this.attributes == null) {
            return defaultValue;
        }
        String value = this.attributes.get(attribute);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Double getAttribute(String attribute, Double defaultValue) {
        if (this.attributes == null) {
            return defaultValue;
        }
        try {
            return Double.valueOf(this.attributes.get(attribute));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Long getAttribute(String attribute, Long defaultValue) {
        if (this.attributes == null) {
            return defaultValue;
        }
        try {
            return Long.valueOf(this.attributes.get(attribute));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Float getAttribute(String attribute, Float defaultValue) {
        if (this.attributes == null) {
            return defaultValue;
        }
        try {
            return Float.valueOf(this.attributes.get(attribute));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Boolean getAttribute(String attribute, Boolean defaultValue) {
        if (this.attributes == null) {
            return defaultValue;
        }
        return Boolean.valueOf(this.attributes.get(attribute));
    }

    public XmlNode setAttribute(String key, String value) {
        this.attributes.put(key, value);
        return this;
    }

    public XmlNode setName(String name) {
        this.name = name;
        return this;
    }

    public SortedSet<XmlNode> getNodes() {
        return this.nodes;
    }

    public int getNodeCount() {
        return this.nodes == null ? 0 : this.nodes.size();
    }

    public XmlNode addNode(XmlNode node) {
        this.nodes.add(node);
        return this;
    }

    public XmlNode addNodes(Collection<XmlNode> list) {
        if (list != null) {
            this.nodes.addAll(list);
        }
        return this;
    }

    public List<XmlNode> getNodesByTagName(String name) {
        ArrayList<XmlNode> list = new ArrayList<XmlNode>();
        for (XmlNode node : this.nodes) {
            if (!node.name.equals(name)) continue;
            list.add(node);
        }
        return list;
    }

    public List<XmlNode> getNodesByAttributeValue(String attribute, String value) {
        ArrayList<XmlNode> list = new ArrayList<XmlNode>();
        for (XmlNode node : this.nodes) {
            String attValue;
            if (node.attributes == null || (attValue = node.attributes.get(attribute)) == null || !attValue.equals(value)) continue;
            list.add(node);
        }
        return list;
    }

    public List<XmlNode> getNodesByAttributeKey(String attribute, String value) {
        ArrayList<XmlNode> list = new ArrayList<XmlNode>();
        for (XmlNode node : this.nodes) {
            String attValue;
            if (node.attributes == null || (attValue = node.attributes.get(attribute)) == null) continue;
            list.add(node);
        }
        return list;
    }

    public List<XmlNode> getNodesByAttributeContainValue(String attribute, String value) {
        ArrayList<XmlNode> list = new ArrayList<XmlNode>();
        for (XmlNode node : this.nodes) {
            String attValue;
            if (node.attributes == null || (attValue = node.attributes.get(attribute)) == null || !attValue.contains(value)) continue;
            list.add(node);
        }
        return list;
    }

    public List<XmlNode> getNodesByAttributeMatchValue(String attribute, String value) {
        ArrayList<XmlNode> list = new ArrayList<XmlNode>();
        for (XmlNode node : this.nodes) {
            String attValue;
            if (node.attributes == null || (attValue = node.attributes.get(attribute)) == null || !attValue.matches(value)) continue;
            list.add(node);
        }
        return list;
    }

    public XmlNode getNodeByTagName(String name) {
        for (XmlNode node : this.nodes) {
            if (!node.name.equals(name)) continue;
            return node;
        }
        return null;
    }

    public XmlNode getNodeByAttributeValue(String attribute, String value) {
        for (XmlNode node : this.nodes) {
            String attValue = node.attributes.get(attribute);
            if (attValue == null || !attValue.equals(value)) continue;
            return node;
        }
        return null;
    }

    public XmlNode getNodeByAttributeKey(String attribute, String value) {
        for (XmlNode node : this.nodes) {
            String attValue = node.attributes.get(attribute);
            if (attValue == null) continue;
            return node;
        }
        return null;
    }

    public XmlNode getNodeByAttributeContainValue(String attribute, String value) {
        for (XmlNode node : this.nodes) {
            String attValue = node.attributes.get(attribute);
            if (attValue == null || !attValue.contains(value)) continue;
            return node;
        }
        return null;
    }

    public XmlNode getNodeByAttributeMatchValue(String attribute, String value) {
        if (this.nodes != null) {
            for (XmlNode node : this.nodes) {
                String attValue;
                if (node.attributes == null || (attValue = node.attributes.get(attribute)) == null || !attValue.matches(value)) continue;
                return node;
            }
        }
        return null;
    }

    public String toString() {
        return this.toString(0);
    }

    private String toString(int tab) {
        StringBuilder sb = new StringBuilder();
        for (int n = 0; n < tab; ++n) {
            sb.append('\t');
        }
        sb.append('<');
        sb.append(this.name);
        for (String key : this.attributes.keySet()) {
            sb.append(' ');
            sb.append(key);
            sb.append('=');
            sb.append('\"');
            sb.append(this.attributes.get(key));
            sb.append('\"');
        }
        if (this.nodes.isEmpty()) {
            sb.append('/');
            sb.append('>');
        } else {
            sb.append('>');
            sb.append('\n');
            for (XmlNode node : this.nodes) {
                sb.append(node.toString(tab + 1));
                sb.append('\n');
            }
            for (int n = 0; n < tab; ++n) {
                sb.append('\t');
            }
            sb.append('<');
            sb.append('/');
            sb.append(this.name);
            sb.append('>');
        }
        return sb.toString();
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        StringOutputStream string = new StringOutputStream(output);
        XmlNode.getBytes(string, this);
        return output.toByteArray();
    }

    private static void getBytes(StringOutputStream output, XmlNode root) throws IOException {
        output.write(60);
        output.append(root.name);
        if (root.attributes != null) {
            for (String key : root.attributes.keySet()) {
                output.write(32);
                output.append(key);
                output.write(61);
                output.write(34);
                output.append(root.attributes.get(key));
                output.write(34);
            }
        }
        if (root.nodes.isEmpty()) {
            output.write(47);
            output.write(62);
        } else {
            output.write(62);
            for (XmlNode node : root.nodes) {
                XmlNode.getBytes(output, node);
            }
            output.write(60);
            output.write(47);
            output.append(root.name);
            output.write(62);
        }
    }

    public void write(OutputStream output) throws IOException {
        StringOutputStream out = new StringOutputStream(output);
        XmlNode.getBytes(out, this);
    }

    @Override
    public int compareTo(XmlNode o) {
        if (o == null || o.getClass() != XmlNode.class) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        int compareTo = this.name.compareTo(o.name);
        if (compareTo != 0) {
            return compareTo;
        }
        if (this.attributes.size() != o.attributes.size()) {
            return this.attributes.size() - o.attributes.size();
        }
        if (this.nodes.size() != o.nodes.size()) {
            return this.nodes.size() - o.nodes.size();
        }
        String tOrder = this.attributes.get("order");
        String oOrder = o.attributes.get("order");
        if (tOrder != null && oOrder != null) {
            compareTo = tOrder.compareTo(oOrder);
            if (compareTo != 0) {
                return compareTo;
            }
        } else {
            if (tOrder != null && oOrder == null) {
                return -1;
            }
            if (tOrder == null && oOrder != null) {
                return 1;
            }
        }
        for (String key : this.attributes.keySet()) {
            String tValue;
            String oValue = o.attributes.get(key);
            if (oValue == null || (compareTo = (tValue = this.attributes.get(key)).compareTo(oValue)) == 0) continue;
            return compareTo;
        }
        for (XmlNode node : this.nodes) {
            if (o.nodes.contains(node)) continue;
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return 31 * (31 + this.name.hashCode()) + this.attributes.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XmlNode other = (XmlNode)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        return !(this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes));
    }

    public static class StringInputStream
    extends InputStream {
        private final InputStream input;

        public StringInputStream(InputStream input) {
            this.input = input;
        }

        @Override
        public int read() throws IOException {
            int c = this.input.read();
            if (c <= 127) {
                return c;
            }
            if (c >> 5 == 6) {
                int i2 = this.input.read();
                return ((c & 0x1F) << 6) + (i2 & 0x3F);
            }
            int i2 = this.input.read();
            int i3 = this.input.read();
            return ((c & 0xF) << 12) + ((i2 & 0x3F) << 6) + (i3 & 0x3F);
        }

        @Override
        public int available() throws IOException {
            return this.input.available();
        }

        @Override
        public void close() throws IOException {
            this.input.close();
        }
    }

    private static class StringOutputStream
    extends OutputStream {
        private final OutputStream output;

        public StringOutputStream(OutputStream output) {
            this.output = output;
        }

        public void append(String text) throws IOException {
            int size = text.length();
            for (int n = 0; n < size; ++n) {
                char c = text.charAt(n);
                if (c <= '\u007f') {
                    this.output.write(c);
                    continue;
                }
                if (c <= '\u07ff') {
                    this.output.write((c >> 6 & 0x1F) + 192);
                    this.output.write((c & 0x3F) + 128);
                    continue;
                }
                this.output.write((c >> 12 & 0xF) + 224);
                this.output.write((c >> 6 & 0x3F) + 128);
                this.output.write((c & 0x3F) + 128);
            }
        }

        @Override
        public void write(int n) throws IOException {
            this.output.write(n);
        }
    }
}

