/*
 * $Id$
 */
package tecgraf.javautils.gui.table;

/**
 * Classe "marcadora", isto , cujo nico objetivo  marcar uma determinada
 * clula para indicar que esta pertence ao "total da coluna", isto , a ltima
 * ou penltima linha de uma tabela de totalizao, que deve manter fixa sua
 * posio, independentemente da ordenao vigente. Esta classe  necessria
 * pois os comparadores de colunas precisam saber quais so as clulas que devem
 * ser fixas para sempre deix-las na base da tabela.
 * 
 * Cada clula tem um peso que  usado pelo comparador. As clulas com maior
 * peso esto mais abaixo na tabela.
 * 
 * @see FooterComparatorWrapper
 * 
 * @author Tecgraf
 */
public class FooterCell {
  /** Valor da clula "marcada" */
  private Object cell;
  /** Peso da clula "marcada" */
  private int weight;

  /**
   * Cria um objeto marcador.
   * 
   * @param cell clula a ser marcada.
   * @param weight peso da clula a ser marcada.
   */
  public FooterCell(Object cell, int weight) {
    this.cell = cell;
    this.weight = weight;
  }

  /**
   * Retorna o valor da clula sendo marcada.
   * 
   * @return valor da clula marcada.
   */
  public Object getValue() {
    return cell;
  }

  /**
   * Retorna o peso da clula sendo marcada.
   * 
   * @return peso da clula marcada.
   */
  int getWeight() {
    return weight;
  }

  /**
   * Retorna este objeto em forma de <code>String</code>. Reproduz o valor da
   * clula marcada.
   * 
   * @return valor da clula marcada em forma de <code>String</code>.
   */
  @Override
  public String toString() {
    return (cell == null) ? null : cell.toString();
  }
}