/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.table;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;

public abstract class TecDefaultRowSorter<M, I>
extends RowSorter<M> {
    private boolean sortsOnUpdates;
    private Row[] viewToModel;
    private int[] modelToView;
    private Comparator[] comparators;
    private boolean[] isSortable;
    private RowSorter.SortKey[] cachedSortKeys;
    private Comparator[] sortComparators;
    private RowFilter<? super M, ? super I> filter;
    private FilterEntry filterEntry;
    private List<RowSorter.SortKey> sortKeys = Collections.emptyList();
    private boolean[] useToString;
    private boolean sorted;
    private int maxSortKeys = 3;
    private ModelWrapper<M, I> modelWrapper;
    private int modelRowCount;
    private boolean nullComparisonEnabled;
    private boolean noSortStateEnabled;

    protected final void setModelWrapper(ModelWrapper<M, I> modelWrapper) {
        if (modelWrapper == null) {
            throw new IllegalArgumentException("modelWrapper most be non-null");
        }
        ModelWrapper<M, I> last = this.modelWrapper;
        this.modelWrapper = modelWrapper;
        if (last != null) {
            this.modelStructureChanged();
        } else {
            this.modelRowCount = this.getModelWrapper().getRowCount();
        }
    }

    protected final ModelWrapper<M, I> getModelWrapper() {
        return this.modelWrapper;
    }

    @Override
    public final M getModel() {
        return this.getModelWrapper().getModel();
    }

    public void setSortable(int column, boolean sortable) {
        this.checkColumn(column);
        if (this.isSortable == null) {
            this.isSortable = new boolean[this.getModelWrapper().getColumnCount()];
            for (int i = this.isSortable.length - 1; i >= 0; --i) {
                this.isSortable[i] = true;
            }
        }
        this.isSortable[column] = sortable;
    }

    public boolean isSortable(int column) {
        this.checkColumn(column);
        return this.isSortable == null ? true : this.isSortable[column];
    }

    @Override
    public void setSortKeys(List<? extends RowSorter.SortKey> sortKeys) {
        List<RowSorter.SortKey> old = this.sortKeys;
        if (sortKeys != null && sortKeys.size() > 0) {
            int max = this.getModelWrapper().getColumnCount();
            for (RowSorter.SortKey sortKey : sortKeys) {
                if (sortKey != null && sortKey.getColumn() >= 0 && sortKey.getColumn() < max) continue;
                throw new IllegalArgumentException("Invalid SortKey");
            }
            this.sortKeys = Collections.unmodifiableList(new ArrayList<RowSorter.SortKey>(sortKeys));
        } else {
            this.sortKeys = Collections.emptyList();
        }
        if (!this.sortKeys.equals(old)) {
            this.fireSortOrderChanged();
            if (this.viewToModel == null) {
                this.sort();
            } else {
                this.sortExistingData();
            }
        }
    }

    @Override
    public List<? extends RowSorter.SortKey> getSortKeys() {
        return this.sortKeys;
    }

    public void setMaxSortKeys(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("Invalid max");
        }
        this.maxSortKeys = max;
    }

    public int getMaxSortKeys() {
        return this.maxSortKeys;
    }

    public void setSortsOnUpdates(boolean sortsOnUpdates) {
        this.sortsOnUpdates = sortsOnUpdates;
    }

    public boolean getSortsOnUpdates() {
        return this.sortsOnUpdates;
    }

    public void setRowFilter(RowFilter<? super M, ? super I> filter) {
        this.filter = filter;
        this.sort();
    }

    public RowFilter<? super M, ? super I> getRowFilter() {
        return this.filter;
    }

    @Override
    public void toggleSortOrder(int column) {
        this.checkColumn(column);
        if (this.isSortable(column)) {
            int sortIndex;
            List<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
            for (sortIndex = keys.size() - 1; sortIndex >= 0 && ((RowSorter.SortKey)keys.get(sortIndex)).getColumn() != column; --sortIndex) {
            }
            if (sortIndex == -1) {
                RowSorter.SortKey sortKey = new RowSorter.SortKey(column, SortOrder.ASCENDING);
                keys.add(0, sortKey);
            } else if (sortIndex == 0) {
                keys.set(0, this.toggle((RowSorter.SortKey)keys.get(0)));
            } else {
                keys.remove(sortIndex);
                keys.add(0, new RowSorter.SortKey(column, SortOrder.ASCENDING));
            }
            if (keys.size() > this.getMaxSortKeys()) {
                keys = keys.subList(0, this.getMaxSortKeys());
            }
            this.setSortKeys(keys);
        }
    }

    private RowSorter.SortKey toggle(RowSorter.SortKey key) {
        switch (key.getSortOrder()) {
            case ASCENDING: {
                return new RowSorter.SortKey(key.getColumn(), SortOrder.DESCENDING);
            }
            case DESCENDING: {
                if (this.noSortStateEnabled) {
                    return new RowSorter.SortKey(key.getColumn(), SortOrder.UNSORTED);
                }
                return new RowSorter.SortKey(key.getColumn(), SortOrder.ASCENDING);
            }
            case UNSORTED: {
                return new RowSorter.SortKey(key.getColumn(), SortOrder.ASCENDING);
            }
        }
        throw new IllegalStateException("key.getSortOrder()==" + (Object)((Object)key.getSortOrder()));
    }

    @Override
    public int convertRowIndexToView(int index) {
        if (this.modelToView == null) {
            if (index < 0 || index >= this.getModelWrapper().getRowCount()) {
                throw new IndexOutOfBoundsException("Invalid index");
            }
            return index;
        }
        return this.modelToView[index];
    }

    @Override
    public int convertRowIndexToModel(int index) {
        if (this.viewToModel == null) {
            if (index < 0 || index >= this.getModelWrapper().getRowCount()) {
                throw new IndexOutOfBoundsException("Invalid index");
            }
            return index;
        }
        return this.viewToModel[index].modelIndex;
    }

    private boolean isUnsorted() {
        List<RowSorter.SortKey> keys = this.getSortKeys();
        int keySize = keys.size();
        return keySize == 0 || keys.get(0).getSortOrder() == SortOrder.UNSORTED;
    }

    private void sortExistingData() {
        int[] lastViewToModel = this.getViewToModelAsInts(this.viewToModel);
        this.updateUseToString();
        this.cacheSortKeys(this.getSortKeys());
        if (this.isUnsorted()) {
            if (this.getRowFilter() == null) {
                this.viewToModel = null;
                this.modelToView = null;
            } else {
                int included = 0;
                for (int i = 0; i < this.modelToView.length; ++i) {
                    if (this.modelToView[i] == -1) continue;
                    this.viewToModel[included].modelIndex = i;
                    this.modelToView[i] = included++;
                }
            }
        } else {
            Arrays.sort(this.viewToModel);
            this.setModelToViewFromViewToModel(false);
        }
        this.fireRowSorterChanged(lastViewToModel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sort() {
        this.sorted = true;
        int[] lastViewToModel = this.getViewToModelAsInts(this.viewToModel);
        this.updateUseToString();
        if (this.isUnsorted()) {
            this.cachedSortKeys = new RowSorter.SortKey[0];
            if (this.getRowFilter() == null) {
                if (this.viewToModel == null) return;
                this.viewToModel = null;
                this.modelToView = null;
            } else {
                this.initializeFilteredMapping();
            }
        } else {
            this.cacheSortKeys(this.getSortKeys());
            if (this.getRowFilter() != null) {
                this.initializeFilteredMapping();
            } else {
                this.createModelToView(this.getModelWrapper().getRowCount());
                this.createViewToModel(this.getModelWrapper().getRowCount());
            }
            Arrays.sort(this.viewToModel);
            this.setModelToViewFromViewToModel(false);
        }
        this.fireRowSorterChanged(lastViewToModel);
    }

    private void updateUseToString() {
        int i = this.getModelWrapper().getColumnCount();
        if (this.useToString == null || this.useToString.length != i) {
            this.useToString = new boolean[i];
        }
        --i;
        while (i >= 0) {
            this.useToString[i] = this.useToString(i);
            --i;
        }
    }

    private void initializeFilteredMapping() {
        int i;
        int rowCount = this.getModelWrapper().getRowCount();
        int excludedCount = 0;
        this.createModelToView(rowCount);
        for (i = 0; i < rowCount; ++i) {
            if (this.include(i)) {
                this.modelToView[i] = i - excludedCount;
                continue;
            }
            this.modelToView[i] = -1;
            ++excludedCount;
        }
        this.createViewToModel(rowCount - excludedCount);
        int j = 0;
        for (i = 0; i < rowCount; ++i) {
            if (this.modelToView[i] == -1) continue;
            this.viewToModel[j++].modelIndex = i;
        }
    }

    private void createModelToView(int rowCount) {
        if (this.modelToView == null || this.modelToView.length != rowCount) {
            this.modelToView = new int[rowCount];
        }
    }

    private void createViewToModel(int rowCount) {
        int i;
        int recreateFrom = 0;
        if (this.viewToModel != null) {
            recreateFrom = Math.min(rowCount, this.viewToModel.length);
            if (this.viewToModel.length != rowCount) {
                Row[] oldViewToModel = this.viewToModel;
                this.viewToModel = new Row[rowCount];
                System.arraycopy(oldViewToModel, 0, this.viewToModel, 0, recreateFrom);
            }
        } else {
            this.viewToModel = new Row[rowCount];
        }
        for (i = 0; i < recreateFrom; ++i) {
            this.viewToModel[i].modelIndex = i;
        }
        for (i = recreateFrom; i < rowCount; ++i) {
            this.viewToModel[i] = new Row(this, i);
        }
    }

    private void cacheSortKeys(List<? extends RowSorter.SortKey> keys) {
        int keySize = keys.size();
        this.sortComparators = new Comparator[keySize];
        for (int i = 0; i < keySize; ++i) {
            this.sortComparators[i] = this.getComparator0(keys.get(i).getColumn());
        }
        this.cachedSortKeys = keys.toArray(new RowSorter.SortKey[keySize]);
    }

    protected boolean useToString(int column) {
        return this.getComparator(column) == null;
    }

    private void setModelToViewFromViewToModel(boolean unsetFirst) {
        int i;
        if (unsetFirst) {
            for (i = this.modelToView.length - 1; i >= 0; --i) {
                this.modelToView[i] = -1;
            }
        }
        for (i = this.viewToModel.length - 1; i >= 0; --i) {
            this.modelToView[this.viewToModel[i].modelIndex] = i;
        }
    }

    private int[] getViewToModelAsInts(Row[] viewToModel) {
        if (viewToModel != null) {
            int[] viewToModelI = new int[viewToModel.length];
            for (int i = viewToModel.length - 1; i >= 0; --i) {
                viewToModelI[i] = viewToModel[i].modelIndex;
            }
            return viewToModelI;
        }
        return new int[0];
    }

    public void setComparator(int column, Comparator<?> comparator) {
        this.checkColumn(column);
        if (this.comparators == null) {
            this.comparators = new Comparator[this.getModelWrapper().getColumnCount()];
        }
        this.comparators[column] = comparator;
    }

    public Comparator<?> getComparator(int column) {
        this.checkColumn(column);
        if (this.comparators != null) {
            return this.comparators[column];
        }
        return null;
    }

    private Comparator getComparator0(int column) {
        Comparator<?> comparator = this.getComparator(column);
        if (comparator != null) {
            return comparator;
        }
        return Collator.getInstance();
    }

    private RowFilter.Entry<M, I> getFilterEntry(int modelIndex) {
        if (this.filterEntry == null) {
            this.filterEntry = new FilterEntry();
        }
        this.filterEntry.modelIndex = modelIndex;
        return this.filterEntry;
    }

    @Override
    public int getViewRowCount() {
        if (this.viewToModel != null) {
            return this.viewToModel.length;
        }
        return this.getModelWrapper().getRowCount();
    }

    @Override
    public int getModelRowCount() {
        return this.getModelWrapper().getRowCount();
    }

    private void allChanged() {
        this.modelToView = null;
        this.viewToModel = null;
        this.comparators = null;
        this.isSortable = null;
        if (this.isUnsorted()) {
            this.sort();
        } else {
            this.setSortKeys(null);
        }
    }

    @Override
    public void modelStructureChanged() {
        this.allChanged();
        this.modelRowCount = this.getModelWrapper().getRowCount();
    }

    @Override
    public void allRowsChanged() {
        this.modelRowCount = this.getModelWrapper().getRowCount();
        this.sort();
    }

    @Override
    public void rowsInserted(int firstRow, int endRow) {
        this.checkAgainstModel(firstRow, endRow);
        int newModelRowCount = this.getModelWrapper().getRowCount();
        if (endRow >= newModelRowCount) {
            throw new IndexOutOfBoundsException("Invalid range");
        }
        this.modelRowCount = newModelRowCount;
        if (this.shouldOptimizeChange(firstRow, endRow)) {
            this.rowsInserted0(firstRow, endRow);
        }
    }

    @Override
    public void rowsDeleted(int firstRow, int endRow) {
        this.checkAgainstModel(firstRow, endRow);
        if (firstRow >= this.modelRowCount || endRow >= this.modelRowCount) {
            throw new IndexOutOfBoundsException("Invalid range");
        }
        this.modelRowCount = this.getModelWrapper().getRowCount();
        if (this.shouldOptimizeChange(firstRow, endRow)) {
            this.rowsDeleted0(firstRow, endRow);
        }
    }

    @Override
    public void rowsUpdated(int firstRow, int endRow) {
        this.checkAgainstModel(firstRow, endRow);
        if (firstRow >= this.modelRowCount || endRow >= this.modelRowCount) {
            throw new IndexOutOfBoundsException("Invalid range");
        }
        if (this.getSortsOnUpdates()) {
            if (this.shouldOptimizeChange(firstRow, endRow)) {
                this.rowsUpdated0(firstRow, endRow);
            }
        } else {
            this.sorted = false;
        }
    }

    @Override
    public void rowsUpdated(int firstRow, int endRow, int column) {
        this.checkColumn(column);
        this.rowsUpdated(firstRow, endRow);
    }

    private void checkAgainstModel(int firstRow, int endRow) {
        if (firstRow > endRow || firstRow < 0 || endRow < 0 || firstRow > this.modelRowCount) {
            throw new IndexOutOfBoundsException("Invalid range");
        }
    }

    private boolean include(int row) {
        RowFilter<M, I> filter = this.getRowFilter();
        if (filter != null) {
            return filter.include(this.getFilterEntry(row));
        }
        return true;
    }

    private int compare(int model1, int model2) {
        for (int counter = 0; counter < this.cachedSortKeys.length; ++counter) {
            int result;
            int column = this.cachedSortKeys[counter].getColumn();
            SortOrder sortOrder = this.cachedSortKeys[counter].getSortOrder();
            if (sortOrder == SortOrder.UNSORTED) {
                result = model1 - model2;
            } else {
                Object v2;
                Object v1;
                if (this.useToString[column]) {
                    v1 = this.getModelWrapper().getStringValueAt(model1, column);
                    v2 = this.getModelWrapper().getStringValueAt(model2, column);
                } else {
                    v1 = this.getModelWrapper().getValueAt(model1, column);
                    v2 = this.getModelWrapper().getValueAt(model2, column);
                }
                result = this.nullComparisonEnabled ? this.sortComparators[counter].compare(v1, v2) : (v1 == null ? (v2 == null ? 0 : -1) : (v2 == null ? 1 : this.sortComparators[counter].compare(v1, v2)));
                if (sortOrder == SortOrder.DESCENDING) {
                    result *= -1;
                }
            }
            if (result == 0) continue;
            return result;
        }
        return model1 - model2;
    }

    private boolean isTransformed() {
        return this.viewToModel != null;
    }

    private void insertInOrder(List<Row> toAdd, Row[] current) {
        int last = 0;
        int max = toAdd.size();
        for (int i = 0; i < max; ++i) {
            int index = Arrays.binarySearch(current, toAdd.get(i));
            if (index < 0) {
                index = -1 - index;
            }
            System.arraycopy(current, last, this.viewToModel, last + i, index - last);
            this.viewToModel[index + i] = toAdd.get(i);
            last = index;
        }
        System.arraycopy(current, last, this.viewToModel, last + max, current.length - last);
    }

    private boolean shouldOptimizeChange(int firstRow, int lastRow) {
        if (!this.isTransformed()) {
            return false;
        }
        if (!this.sorted || lastRow - firstRow > this.viewToModel.length / 10) {
            this.sort();
            return false;
        }
        return true;
    }

    private void rowsInserted0(int firstRow, int lastRow) {
        int i;
        int[] oldViewToModel = this.getViewToModelAsInts(this.viewToModel);
        int delta = lastRow - firstRow + 1;
        ArrayList<Row> added = new ArrayList<Row>(delta);
        for (i = firstRow; i <= lastRow; ++i) {
            if (!this.include(i)) continue;
            added.add(new Row(this, i));
        }
        for (i = this.modelToView.length - 1; i >= firstRow; --i) {
            int viewIndex = this.modelToView[i];
            if (viewIndex == -1) continue;
            this.viewToModel[viewIndex].modelIndex += delta;
        }
        if (added.size() > 0) {
            Collections.sort(added);
            Row[] lastViewToModel = this.viewToModel;
            this.viewToModel = new Row[this.viewToModel.length + added.size()];
            this.insertInOrder(added, lastViewToModel);
        }
        this.createModelToView(this.getModelWrapper().getRowCount());
        this.setModelToViewFromViewToModel(true);
        this.fireRowSorterChanged(oldViewToModel);
    }

    private void rowsDeleted0(int firstRow, int lastRow) {
        int viewIndex;
        int i;
        int[] oldViewToModel = this.getViewToModelAsInts(this.viewToModel);
        int removedFromView = 0;
        for (i = firstRow; i <= lastRow; ++i) {
            viewIndex = this.modelToView[i];
            if (viewIndex == -1) continue;
            ++removedFromView;
            this.viewToModel[viewIndex] = null;
        }
        int delta = lastRow - firstRow + 1;
        for (i = this.modelToView.length - 1; i > lastRow; --i) {
            viewIndex = this.modelToView[i];
            if (viewIndex == -1) continue;
            this.viewToModel[viewIndex].modelIndex -= delta;
        }
        if (removedFromView > 0) {
            Row[] newViewToModel = new Row[this.viewToModel.length - removedFromView];
            int newIndex = 0;
            int last = 0;
            for (i = 0; i < this.viewToModel.length; ++i) {
                if (this.viewToModel[i] != null) continue;
                System.arraycopy(this.viewToModel, last, newViewToModel, newIndex, i - last);
                newIndex += i - last;
                last = i + 1;
            }
            System.arraycopy(this.viewToModel, last, newViewToModel, newIndex, this.viewToModel.length - last);
            this.viewToModel = newViewToModel;
        }
        this.createModelToView(this.getModelWrapper().getRowCount());
        this.setModelToViewFromViewToModel(true);
        this.fireRowSorterChanged(oldViewToModel);
    }

    private void rowsUpdated0(int firstRow, int lastRow) {
        int[] oldViewToModel = this.getViewToModelAsInts(this.viewToModel);
        int delta = lastRow - firstRow + 1;
        if (this.getRowFilter() == null) {
            Object[] updated = new Row[delta];
            int j = 0;
            int i = firstRow;
            while (i <= lastRow) {
                updated[j] = this.viewToModel[this.modelToView[i]];
                ++i;
                ++j;
            }
            Arrays.sort(updated);
            Row[] intermediary = new Row[this.viewToModel.length - delta];
            j = 0;
            for (i = 0; i < this.viewToModel.length; ++i) {
                int modelIndex = this.viewToModel[i].modelIndex;
                if (modelIndex >= firstRow && modelIndex <= lastRow) continue;
                intermediary[j++] = this.viewToModel[i];
            }
            this.insertInOrder(Arrays.asList(updated), intermediary);
            this.setModelToViewFromViewToModel(false);
        } else {
            int i;
            ArrayList<Row> updated = new ArrayList<Row>(delta);
            int newlyVisible = 0;
            int newlyHidden = 0;
            int effected = 0;
            for (i = firstRow; i <= lastRow; ++i) {
                if (this.modelToView[i] == -1) {
                    if (!this.include(i)) continue;
                    updated.add(new Row(this, i));
                    ++newlyVisible;
                    continue;
                }
                if (!this.include(i)) {
                    ++newlyHidden;
                } else {
                    updated.add(this.viewToModel[this.modelToView[i]]);
                }
                this.modelToView[i] = -2;
                ++effected;
            }
            Collections.sort(updated);
            Row[] intermediary = new Row[this.viewToModel.length - effected];
            int j = 0;
            for (i = 0; i < this.viewToModel.length; ++i) {
                int modelIndex = this.viewToModel[i].modelIndex;
                if (this.modelToView[modelIndex] == -2) continue;
                intermediary[j++] = this.viewToModel[i];
            }
            if (newlyVisible != newlyHidden) {
                this.viewToModel = new Row[this.viewToModel.length + newlyVisible - newlyHidden];
            }
            this.insertInOrder(updated, intermediary);
            this.setModelToViewFromViewToModel(true);
        }
        this.fireRowSorterChanged(oldViewToModel);
    }

    private void checkColumn(int column) {
        if (column < 0 || column >= this.getModelWrapper().getColumnCount()) {
            throw new IndexOutOfBoundsException("column beyond range of TableModel");
        }
    }

    public void setNullComparison(boolean enable) {
        this.nullComparisonEnabled = enable;
    }

    public boolean getNoSortEnabled() {
        return this.noSortStateEnabled;
    }

    public void setNoSortEnabled(boolean enable) {
        this.noSortStateEnabled = enable;
    }

    private static class Row
    implements Comparable<Row> {
        private TecDefaultRowSorter sorter;
        int modelIndex;

        public Row(TecDefaultRowSorter sorter, int index) {
            this.sorter = sorter;
            this.modelIndex = index;
        }

        @Override
        public int compareTo(Row o) {
            return this.sorter.compare(this.modelIndex, o.modelIndex);
        }
    }

    private class FilterEntry
    extends RowFilter.Entry<M, I> {
        int modelIndex;

        private FilterEntry() {
        }

        @Override
        public M getModel() {
            return TecDefaultRowSorter.this.getModelWrapper().getModel();
        }

        @Override
        public int getValueCount() {
            return TecDefaultRowSorter.this.getModelWrapper().getColumnCount();
        }

        @Override
        public Object getValue(int index) {
            return TecDefaultRowSorter.this.getModelWrapper().getValueAt(this.modelIndex, index);
        }

        @Override
        public String getStringValue(int index) {
            return TecDefaultRowSorter.this.getModelWrapper().getStringValueAt(this.modelIndex, index);
        }

        @Override
        public I getIdentifier() {
            return TecDefaultRowSorter.this.getModelWrapper().getIdentifier(this.modelIndex);
        }
    }

    protected static abstract class ModelWrapper<M, I> {
        protected ModelWrapper() {
        }

        public abstract M getModel();

        public abstract int getColumnCount();

        public abstract int getRowCount();

        public abstract Object getValueAt(int var1, int var2);

        public String getStringValueAt(int row, int column) {
            Object o = this.getValueAt(row, column);
            if (o == null) {
                return "";
            }
            String string = o.toString();
            if (string == null) {
                return "";
            }
            return string;
        }

        public abstract I getIdentifier(int var1);
    }
}

