package tecgraf.javautils.gui.crud.gui.edition;

import java.awt.Container;

import javax.swing.JPanel;

import tecgraf.javautils.gui.crud.IRegistrationEditionPanel;
import tecgraf.javautils.gui.crud.gui.main.RegistrationMainPanel;
import tecgraf.javautils.gui.crud.gui.main.RegistrationMainPanel.Mode;
import tecgraf.javautils.gui.crud.gui.main.RegistrationModeListener;

/**
 * Painel de edio do objeto de interface.
 * 
 * @author Tecgraf
 * @param <M> tipo do objeto do modelo.
 * @param <I> tipo do objeto da interface.
 */
public abstract class RegistrationEditionPanel<M, I> implements
  IRegistrationEditionPanel<I> {

  /**
   * Painel principal.
   */
  final private RegistrationMainPanel<M, I> mainPanel;

  /**
   * Painel swing propriamente.
   */
  private JPanel registrationEditPanel;

  /**
   * Construtor.
   * 
   * @param mainPanel painel
   */
  public RegistrationEditionPanel(final RegistrationMainPanel<M, I> mainPanel) {
    this.mainPanel = mainPanel;
    addAddModeListener();
    addViewModeListener();
    addEditModeListener();
  }

  /**
   * Adio de listener: adio.
   */
  private void addAddModeListener() {
    mainPanel.addModeListener(new RegistrationModeListener() {
      @Override
      public void modeChanged(Mode oldMode, Mode newMode) {
        if (newMode == Mode.ADD) {
          clearIHC();
          setReadOnlyIHC(false);
        }
      }
    });
  }

  /**
   * Adio de listener: adio.
   */
  private void addEditModeListener() {
    mainPanel.addModeListener(new RegistrationModeListener() {
      @Override
      public void modeChanged(Mode oldMode, Mode newMode) {
        if (newMode == Mode.EDIT) {
          final I object = mainPanel.getSelectedIHCObject();
          if (object != null) {
            setObjectToIHC(object);
          }
          setReadOnlyIHC(false);
        }
      }
    });
  }

  /**
   * Adio de listener: adio.
   */
  private void addViewModeListener() {
    mainPanel.addModeListener(new RegistrationModeListener() {
      @Override
      public void modeChanged(Mode oldMode, Mode newMode) {
        if (newMode == Mode.VIEW) {
          clearIHC();
          final I object = mainPanel.getSelectedIHCObject();
          if (object != null) {
            setObjectToIHC(object);
          }
          setReadOnlyIHC(true);
        }
      }
    });
  }

  /**
   * Sinalizao de objeto editado.
   * 
   * @param flag indicativo.
   */
  public void signalObjectEdited(final boolean flag) {
    mainPanel.signalObjectEdited(flag);
  }

  /**
   * Delega a obteno do container de edio para a aplicao especfica
   * 
   * @return editingPanel container de edio.
   */
  public Container getContainer() {
    if (registrationEditPanel == null) {
      registrationEditPanel = new JPanel();
    }
    return registrationEditPanel;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract I getObjectFromIHC();

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract void setObjectToIHC(I object);

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract void setReadOnlyIHC(boolean readOnly);

  /**
   * {@inheritDoc}
   */
  @Override
  public abstract void clearIHC();

}
