/*
 * $Id$
 */
package tecgraf.javautils.gui.print;

import java.awt.Graphics2D;
import java.awt.print.PageFormat;

/**
 * Item do relatrio a ser impresso. Como o <code>PageFormat</code> pode mudar a
 * cada chamada, a implementao deve guardar qual foi o ltimo objeto
 * desenhado.
 */
public interface PrintableReportItem {
  /** Converso de cm para 1/72 de polegada */
  public static final double CM_TO_INCH = 0.393700787 * 72;

  /**
   * Simula a impresso do item, isto , gera a impresso no componente grfico
   * como se estivesse imprimindo, mas sem imprimir de fato.
   * 
   * @param g2 componente grfico.
   * @param format formato da pgina a ser impressa.
   * @param pageIndex ndice da pgina a ser impressa.
   * 
   * @return verdadeiro se o item foi totalmente impresso.
   */
  public boolean simulatePrint(Graphics2D g2, PageFormat format, int pageIndex);

  /**
   * Imprime o item.
   * 
   * @param g2 componente grfico.
   * @param format formato da pgina a ser impressa.
   * @param pageIndex ndice da pgina a ser impressa.
   * 
   * @return verdadeiro se o item foi totalmente impresso.
   */
  public boolean print(Graphics2D g2, PageFormat format, int pageIndex);

  /**
   * Obtm a altura do item impresso na pgina.
   * 
   * @return altura do item impresso na pgina.
   */
  public float getHeight();

  /**
   * Obtm a largura do item impresso na pgina.
   * 
   * @return largura do item impresso na pgina.
   */
  public float getWidth();

  /**
   * Prepara a impresso com determinada configurao de impresso.
   * 
   * @param configuration configurao de impresso.
   */
  public void initPrinting(PrintConfiguration configuration);
}
