package tecgraf.javautils.gui.table;

/**
 * <p>
 * A interface <code>ObjectTableProvider</code>  usada conjuntamente com a
 * classe <code>ObjectTableModel</code>. Ela permite que o desenvolvedor fornea
 * dados para uma tabela sem ter que construir um modelo.
 * </p>
 * <p>
 * Objetos que implementam essa interface devem especificar um array para os
 * cabealhos das colunas (<code>getColumnNames()</code>); outro array
 * especificando o tipo de dados em cada coluna (<code>getColumnClasses()</code>
 * ); e finalmente descrever a forma de se extrair o valor de cada coluna, dado
 * um objeto que contenha todas as informaes de uma linha (
 * <code>getCellValues(Object)</code>).
 * </p>
 * 
 * @param <T> tipo associado a cada linha da tabela
 * 
 * @author $Author: costa $
 * @version $Revision: 119233 $
 * @see tecgraf.javautils.gui.table.ObjectTableModel
 */
public interface ObjectTableProvider<T> {
  /**
   * Obtm um array com os <b>nomes das colunas</b> para ser usado como
   * cabealho da tabela.
   * 
   * @return array de nomes para o cabealho da tabela.
   */
  String[] getColumnNames();

  /**
   * Obtm um array com as classes que representam os objetos por coluna na
   * tabela.
   * 
   * @return array com as classes que representam os objetos por coluna na
   *         tabela.
   */
  Class<?>[] getColumnClasses();

  /**
   * Dado um objeto que representa uma linha, retorna o valor associado a uma
   * determinada coluna. Este valor deve ser um objeto associado ao tipo
   * primitivo do dado, e no uma string formatada.
   * 
   * @param row objeto que representa a linha
   * @param col coluna
   * @return valor associado  clula solicitada
   */
  Object getCellValue(T row, int col);
}
