package tecgraf.javautils.gui.table;

/**
 * Interface que estende a <code>ObjectTableProvider</code>, permitindo ao
 * desenvolvedor criar uma tabela editvel. Os mtodos dessa interface indicam
 * quais clulas podem ser editadas (<code>isCellEditable(int,int)</code>) e
 * como deve ser feita a edio no objeto que representa uma linha da tabela (
 * <code>setValueAt(Object, Objec,t int)</code>).
 * 
 * @author lbarros
 * @param <T> tipo associado a cada linha da tabela
 * @see tecgraf.javautils.gui.table.ObjectTableProvider
 */
public interface ModifiableObjectTableProvider<T> extends
  ObjectTableProvider<T> {

  /**
   * Mtodo chamado pela tabela logo aps o usurio ter editado uma das clulas
   * da tabela. Especifica como atualizar o objeto-linha com o valor entrado
   * pelo usurio na coluna especificada.
   * 
   * @param row objeto representando uma linha da tabela.
   * @param newValue valor digitado pelo usurio, para substituir o valor atual
   *        da informao no objeto-linha.
   * @param colIndex ndice da coluna na tabela, a ser mapeada para a
   *        propriedade correta do objeto-linha.
   */
  void setValueAt(T row, Object newValue, int colIndex);

  /**
   * Indica para a tabela se ela deve permitir ou no a edio em determinada
   * clula.
   * 
   * @param rowIndex ndice da linha da clula.
   * @param columnIndex ndice da coluna da clula.
   * 
   * @return <code>true</code> caso a clula possa ser editada,
   *         <code>false</code> caso contrrio.
   */
  boolean isCellEditable(int rowIndex, int columnIndex);
}
