package tecgraf.javautils.gui.print;

import java.awt.Font;
import java.util.ArrayList;
import java.util.List;

import javax.swing.SwingUtilities;

/**
 * Exemplo de uso da classe {@link PrintSimulator}.
 *
 * @author Tecgraf/PUC-Rio
 */
public class PrintSimulatorSample {

  /**
   * Mtodo de teste para a classe.
   * 
   * @param args no utilizados.
   */
  public static void main(String[] args) {
    List<PrintableReportItem> items = new ArrayList<PrintableReportItem>();
    items.add(new PrintableText("Teste", Font.getFont("Verdana")));
    final PrintableReport report = new DefaultPrintableReport(items);

    SwingUtilities.invokeLater(new Runnable() {
      @Override
      public void run() {
        new PrintSimulator(report);
      }
    });
  }
}
