/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.tree;

import javax.swing.JFrame;
import tecgraf.javautils.gui.tree.DefaultNode;
import tecgraf.javautils.gui.tree.FilterableTreePanel;
import tecgraf.javautils.gui.tree.Node;

public final class FilterableTreePanelSample {
    public static void main(String[] args) {
        int[] childCountsPerLevel = new int[args.length];
        for (int argIx = 0; argIx < args.length; ++argIx) {
            try {
                int childCount;
                childCountsPerLevel[argIx] = childCount = Integer.parseInt(args[argIx]);
                if (childCount >= 0) continue;
                FilterableTreePanelSample.showUsage();
                System.exit(1);
                continue;
            }
            catch (NumberFormatException e) {
                FilterableTreePanelSample.showUsage();
                System.exit(1);
            }
        }
        DefaultNode rootNode = FilterableTreePanelSample.createTree(childCountsPerLevel);
        FilterableTreePanel panel = new FilterableTreePanel(rootNode);
        JFrame frame = new JFrame("Exemplo de \u00e1rvore filtr\u00e1vel");
        frame.add(panel);
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private static String createLabel(DefaultNode parentNode, int levelIndex, int childIndex) {
        String parentLabel = parentNode.getLabel();
        String separator = (parentLabel = parentLabel.replaceAll("[0-9]:", "")).length() == 0 ? "" : parentLabel + ".";
        return levelIndex + 1 + ":" + separator + (childIndex + 1);
    }

    private static void createTree(DefaultNode parentNode, int[] childCountsPerLevel, int levelIndex) {
        int childCount = childCountsPerLevel[levelIndex];
        for (int childIndex = 0; childIndex < childCount; ++childIndex) {
            Node.FiltrageMode mode = FilterableTreePanelSample.getFiltrageMode(levelIndex, childIndex, childCountsPerLevel.length - 1);
            DefaultNode childNode = new DefaultNode(FilterableTreePanelSample.createLabel(parentNode, levelIndex, childIndex), mode);
            int nextLevelIndex = levelIndex + 1;
            if (nextLevelIndex < childCountsPerLevel.length) {
                FilterableTreePanelSample.createTree(childNode, childCountsPerLevel, nextLevelIndex);
            }
            parentNode.addChild(childNode);
        }
    }

    private static Node.FiltrageMode getFiltrageMode(int levelIndex, int nodeIndex, int maxLevelIndex) {
        if (maxLevelIndex == levelIndex) {
            Node.FiltrageMode[] modes = Node.FiltrageMode.values();
            return modes[nodeIndex % modes.length];
        }
        return Node.FiltrageMode.EVALUATE;
    }

    private static DefaultNode createTree(int[] childCountsPerLevel) {
        DefaultNode rootNode = new DefaultNode("0:");
        if (childCountsPerLevel.length > 0) {
            FilterableTreePanelSample.createTree(rootNode, childCountsPerLevel, 0);
        }
        return rootNode;
    }

    private static void showUsage() {
        String programCall = String.format("java %s", FilterableTreePanelSample.class.getName());
        StringBuilder usage = new StringBuilder();
        usage.append("Uso:");
        usage.append("\n");
        usage.append("\t");
        usage.append(programCall);
        usage.append(" 0..*[<quantidade_de_n\u00f3s_por_n\u00edvel>]");
        usage.append("\n");
        usage.append("\n");
        usage.append("\t");
        usage.append("quantidade_de_n\u00f3s_por_n\u00edvel: n\u00famero de n\u00f3s em cada n\u00edvel da \u00e1rvore.");
        usage.append("\n");
        usage.append("\n");
        usage.append("Exemplo:");
        usage.append("\n");
        usage.append("\t");
        usage.append(programCall);
        usage.append(" 2 3 4");
        usage.append("\n");
        usage.append("\n");
        usage.append("\t");
        usage.append("Cria uma \u00e1rvore com 4 n\u00edveis:");
        usage.append("\n");
        usage.append("\t");
        usage.append("* N\u00edvel 1: ra\u00edz oculta.");
        usage.append("\n");
        usage.append("\t");
        usage.append("* N\u00edvel 2: 2 elementos.");
        usage.append("\n");
        usage.append("\t");
        usage.append("* N\u00edvel 3: 3 elementos.");
        usage.append("\n");
        usage.append("\t");
        usage.append("* N\u00edvel 4: 4 elementos.");
        usage.append("\n");
        System.err.println(usage);
    }
}

