/*
 * $Id: BorderUtil.java 98073 2009-10-26 19:26:33Z clinio $
 */
package tecgraf.javautils.gui;

import java.awt.Font;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

/**
 * Utilitrio para criao de bordas em componentes de interface.
 *
 * @author Tecgraf/PUC-Rio
 */
public class BorderUtil {

  /**
   * Margem de criao de bordas
   */
  final static private int BRD_GAP = 3;

  /**
   * Fonte padro para ttulo do mtodo
   * {@link #setSimpleTitledBorder(JComponent, String, Font)}
   */
  final static public Font STD_FONT = new Font(Font.SANS_SERIF, Font.BOLD, 16);

  /**
   * Colocao de uma borda com linha e texto em um componente.
   *
   * @param component o componente a ser colocado sob a borda.
   * @param title o ttulo a ser colocado.
   */
  public static void setEtchedBorder(final JComponent component,
    final String title) {
    component.setBorder(BorderFactory.createCompoundBorder(BorderFactory
      .createEmptyBorder(BorderUtil.BRD_GAP, BorderUtil.BRD_GAP,
        BorderUtil.BRD_GAP, BorderUtil.BRD_GAP), BorderFactory
          .createCompoundBorder(BorderFactory.createEtchedBorder(),
            BorderFactory.createEmptyBorder(BorderUtil.BRD_GAP,
              BorderUtil.BRD_GAP, BorderUtil.BRD_GAP, BorderUtil.BRD_GAP))));
  }

  /**
   * Colocao de uma borda de linha em um componente.
   *
   * @param component o componente a ser colocado sob a borda.
   */
  public static void setLinedBorder(final JComponent component) {
    BorderUtil.setTitledBorder(component, "");
  }

  /**
   * Colocao de uma borda rebaixada em um componente.
   *
   * @param component o componente a ser colocado sob a borda.
   */
  public static void setLowBorder(final JComponent component) {
    final CompoundBorder border = BorderFactory.createCompoundBorder(
      BorderFactory.createEmptyBorder(BorderUtil.BRD_GAP, BorderUtil.BRD_GAP,
        BorderUtil.BRD_GAP, BorderUtil.BRD_GAP), BorderFactory
          .createCompoundBorder(BorderFactory.createLoweredBevelBorder(),
            BorderFactory.createEmptyBorder(BorderUtil.BRD_GAP,
              BorderUtil.BRD_GAP, BorderUtil.BRD_GAP, BorderUtil.BRD_GAP)));
    component.setBorder(border);
  }

  /**
   * Colocao de uma borda com linha e texto em um componente.
   *
   * @param component o componente a ser colocado sob a borda.
   * @param title o ttulo a ser colocado.
   */
  public static void setTitledBorder(final JComponent component,
    final String title) {
    component.setBorder(BorderFactory.createCompoundBorder(BorderFactory
      .createEmptyBorder(BorderUtil.BRD_GAP, BorderUtil.BRD_GAP,
        BorderUtil.BRD_GAP, BorderUtil.BRD_GAP), BorderFactory
          .createCompoundBorder(BorderFactory.createTitledBorder(title),
            BorderFactory.createEmptyBorder(BorderUtil.BRD_GAP,
              BorderUtil.BRD_GAP, BorderUtil.BRD_GAP, BorderUtil.BRD_GAP))));
  }

  /**
   * Colocao de uma borda nula com insets compatveis com as definies
   * padronizadas de insets (utilitrio para a montagem de exemplos com
   * componentes alinhados).
   *
   * @param component o componente a ser colocado sob a borda nula.
   */
  public static void setEmptyBorder(final JComponent component) {
    component.setBorder(BorderFactory.createCompoundBorder(BorderFactory
      .createEmptyBorder(BorderUtil.BRD_GAP, BorderUtil.BRD_GAP,
        BorderUtil.BRD_GAP, BorderUtil.BRD_GAP), BorderFactory
          .createCompoundBorder(BorderFactory.createEmptyBorder(), BorderFactory
            .createEmptyBorder(BorderUtil.BRD_GAP, BorderUtil.BRD_GAP,
              BorderUtil.BRD_GAP, BorderUtil.BRD_GAP))));
  }

  /**
   * Colocao de uma borda de texto (sem outra decorao qualquer) em um
   * componente.
   *
   * @param component o componente a ser colocado sob a borda.
   * @param title o ttulo a ser colocado.
   * @param font fonte do ttulo (ver {@link #STD_FONT} com default)
   */
  public static void setSimpleTitledBorder(final JComponent component,
    final String title, final Font font) {
    final Border txtBorder = new TitledBorder(BorderFactory.createEmptyBorder(),
      title, TitledBorder.LEFT, TitledBorder.ABOVE_TOP, font);

    component.setBorder(BorderFactory.createCompoundBorder(BorderFactory
      .createEmptyBorder(BorderUtil.BRD_GAP, BorderUtil.BRD_GAP,
        BorderUtil.BRD_GAP, BorderUtil.BRD_GAP), BorderFactory
          .createCompoundBorder(txtBorder, BorderFactory.createEmptyBorder(
            BorderUtil.BRD_GAP, BorderUtil.BRD_GAP, BorderUtil.BRD_GAP,
            BorderUtil.BRD_GAP))));
  }
}
