package tecgraf.javautils.gui;

import javax.swing.ImageIcon;


/**
 * Interface que disponibiliza recursos grficos (cones para botes, labels...)
 * para uso das classes grficas da biblioteca. ATENO: as constantes aqui so
 * carregadas na primeira referncia  interface e somente sero recarregadas se
 * a JVM for reiniciada.
 * 
 * @author Leonardo Barros
 */
public interface GUIResources {
  // ==========================================================================
  // CONES DE BOTES
  // ==========================================================================

  /** cone de limpeza em boto */
  ImageIcon BUTTON_CLEAR_ICON = GUIUtils.createIcon(Config.BUTTON_DIRECTORY,
    Config.BUTTON_CLEAR_ICON_NAME);

  /** cone de composio de mail/notificao em boto (padro adaptado) */
  ImageIcon BUTTON_MAIL_ICON = GUIUtils.createIcon(Config.BUTTON_DIRECTORY,
    Config.BUTTON_MAIL_ICON_NAME);

  /** cone padro de ajuda em boto */
  ImageIcon BUTTON_HELP_ICON = GUIUtils.createIcon(Config.BUTTON_DIRECTORY,
    Config.BUTTON_HELP_ICON_NAME);

  /** cone padro de monitorao em boto */
  ImageIcon BUTTON_MONITOR_ICON = GUIUtils.createIcon(Config.BUTTON_DIRECTORY,
    Config.BUTTON_MONITOR_ICON_NAME);

  /** cone padro de ajuda em boto */
  ImageIcon BUTTON_FILE_CHOOSER_ICON = GUIUtils.createIcon(
    Config.BUTTON_DIRECTORY, Config.BUTTON_FILE_CHOOSER_ICON_NAME);

  /** cone padro de preview. */
  ImageIcon BUTTON_PREVIEW_ICON = GUIUtils.createIcon(Config.BUTTON_DIRECTORY,
    Config.BUTTON_PREVIEW_ICON_NAME);

  /** cone padro de ajuda em boto */
  ImageIcon BUTTON_DETAIL_ICON = GUIUtils.createIcon(Config.BUTTON_DIRECTORY,
    Config.BUTTON_DETAIL_ICON_NAME);

  /** cone padro do calendrio em boto */
  ImageIcon BUTTON_CALENDAR_ICON = GUIUtils.createIcon(Config.BUTTON_DIRECTORY,
    Config.BUTTON_CALENDAR_ICON_NAME);

  /**
   * cone padro para a seta  direita usada em botes do tipo
   * <code>MenuButton</code>.
   */
  ImageIcon BUTTON_ARROW_RIGHT_ICON = GUIUtils.createIcon(
    Config.BUTTON_DIRECTORY, Config.BUTTON_ARROW_RIGHT_ICON_NAME);

  /**
   * cone padro para a seta para baixo usada em botes do tipo
   * <code>MenuButton</code>.
   */
  ImageIcon BUTTON_ARROW_DOWN_ICON = GUIUtils.createIcon(
    Config.BUTTON_DIRECTORY, Config.BUTTON_ARROW_DOWN_ICON_NAME);

  /**
   * cone padro para a seta para cima usada em botes do tipo
   * <code>MenuButton</code>.
   */
  ImageIcon BUTTON_ARROW_UP_ICON = GUIUtils.createIcon(Config.BUTTON_DIRECTORY,
    Config.BUTTON_ARROW_UP_ICON_NAME);

  /**
   * cone padro para a seta para a esquerda usada em botes do tipo
   * <code>MenuButton</code>.
   */
  ImageIcon BUTTON_ARROW_LEFT_ICON = GUIUtils.createIcon(
    Config.BUTTON_DIRECTORY, Config.BUTTON_ARROW_LEFT_ICON_NAME);

  // ==========================================================================
  // CONES DE LABELS
  // ==========================================================================

  /**
   * cone padro de "warning" em label ("large") Utilizado tipicamente em
   * painis de "warning"
   */
  ImageIcon LABEL_WARNING_LARGE_ICON = GUIUtils.createIcon(
    Config.LABEL_DIRECTORY, Config.LABEL_WARNING_LARGE_ICON_NAME);

  /**
   * cone padro de "question" em label ("large") Utilizado tipicamente em
   * painis de "question"
   */
  ImageIcon LABEL_QUESTION_LARGE_ICON = GUIUtils.createIcon(
    Config.LABEL_DIRECTORY, Config.LABEL_QUESTION_LARGE_ICON_NAME);

  /**
   * cone padro de erro em label ("large") Utilizado tipicamente em painis de
   * erro
   */
  ImageIcon LABEL_ERROR_LARGE_ICON = GUIUtils.createIcon(
    Config.LABEL_DIRECTORY, Config.LABEL_ERROR_LARGE_ICON_NAME);

  /** cone de erro para <code>JLabel</code> */
  ImageIcon LABEL_ERROR_ICON = GUIUtils.createIcon(Config.LABEL_DIRECTORY,
    Config.LABEL_ERROR_ICON_NAME);

  // ==========================================================================
  // CONES DE STATUS
  // ==========================================================================

  /**
   * cone de status nvel "error".
   */
  ImageIcon STATUS_ERROR_ICON = GUIUtils.createIcon(Config.STATUS_DIRECTORY,
    Config.STATUS_ERROR_ICON_NAME);

  /**
   * cone de status nvel "info".
   */
  ImageIcon STATUS_INFO_ICON = GUIUtils.createIcon(Config.STATUS_DIRECTORY,
    Config.STATUS_INFO_ICON_NAME);

  /**
   * cone de status nvel "warning".
   */
  ImageIcon STATUS_WARNING_ICON = GUIUtils.createIcon(Config.STATUS_DIRECTORY,
    Config.STATUS_WARNING_ICON_NAME);

  // ==========================================================================
  // CONES DO WIZARD
  // ==========================================================================

  /** cone de avano. */
  ImageIcon FORWARD_ICON = GUIUtils.createIcon(Config.WIZARD_DIRECTORY,
    Config.FORWARD_ICON_NAME);

  /** cone de retrocesso. */
  ImageIcon BACK_ICON = GUIUtils.createIcon(Config.WIZARD_DIRECTORY,
    Config.BACK_ICON_NAME);
  // ==========================================================================
  // CONES DO CONTAINER SELECTOR
  // ==========================================================================

  /** cone de adicionar todos. */
  ImageIcon SELECTOR_ADDALL_ICON = GUIUtils.createIcon(
    Config.SELECTOR_DIRECTORY, Config.SELECTOR_ADDALL_ICON_NAME);

  /** cone de adicionar. */
  ImageIcon SELECTOR_ADD_ICON = GUIUtils.createIcon(Config.SELECTOR_DIRECTORY,
    Config.SELECTOR_ADD_ICON_NAME);

  /** cone de remover todos. */
  ImageIcon SELECTOR_REMOVEALL_ICON = GUIUtils.createIcon(
    Config.SELECTOR_DIRECTORY, Config.SELECTOR_REMOVEALL_ICON_NAME);

  /** cone de remover. */
  ImageIcon SELECTOR_REMOVE_ICON = GUIUtils.createIcon(
    Config.SELECTOR_DIRECTORY, Config.SELECTOR_REMOVE_ICON_NAME);

  /** cone de restaurar default. */
  ImageIcon SELECTOR_RESTORE_ICON = GUIUtils.createIcon(
    Config.SELECTOR_DIRECTORY, Config.SELECTOR_RESTORE_ICON_NAME);

  /*
   * ==========================================================================
   * Painis expansveis (ExpandablePanel)
   * ==========================================================================
   */
  /**
   * cone do boto "expandir".
   */
  ImageIcon BUTTON_EXPAND_ICON = GUIUtils.createIcon(Config.BUTTON_DIRECTORY,
    Config.BUTTON_EXPAND_ICON_NAME);

  /**
   * cone do boto "fechar".
   */
  ImageIcon BUTTON_COLLAPSE_ICON = GUIUtils.createIcon(Config.BUTTON_DIRECTORY,
    Config.BUTTON_COLLAPSE_ICON_NAME);

  /**
   * cone do boto "expandir todos".
   */
  ImageIcon BUTTON_EXPAND_ALL_ICON = GUIUtils.createIcon(
    Config.BUTTON_DIRECTORY, Config.BUTTON_EXPAND_ALL_ICON_NAME);

  /**
   * cone do boto "fechar todos".
   */
  ImageIcon BUTTON_COLLAPSE_ALL_ICON = GUIUtils.createIcon(
    Config.BUTTON_DIRECTORY, Config.BUTTON_COLLAPSE_ALL_ICON_NAME);
}
