package tecgraf.javautils.gui.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;

/**
 * Exemplo de uso da classe {@link TextTool}.
 *
 * @author Tecgraf/PUC-Rio
 */
public class TextToolSample {
  /**
   * Mtodo de teste da classe.
   * 
   * @param arg argumentos passados na linha de comando.
   * 
   * @throws Exception erro na impresso.
   */
  public static void main(String[] arg) throws Exception {
    PrinterJob job = PrinterJob.getPrinterJob();
    job.setPrintable(new Printable() {
      int pos = 0;
      int lastPos = 0;
      int lastPage = 0;
      boolean finished = false;

      public int print(Graphics g, PageFormat format, int page) {
        if (finished && page > lastPage)
          return NO_SUCH_PAGE;
        Graphics2D g2d = (Graphics2D) g;
        g2d.setPaint(Color.black);
        g2d.setFont(new Font("SansSerif", Font.PLAIN, 8));
        float df = 20;
        float x = (float) format.getImageableX() + df;
        float y = (float) format.getImageableY() + df;
        float w = (float) format.getImageableWidth() - df;
        float h = (float) format.getImageableHeight() - df;
        float dx = w / 4;
        Point2D pt = new Point2D.Float(x + dx, y);
        Rectangle2D rect = new Rectangle2D.Float();
        Ellipse2D dot = new Ellipse2D.Float();
        TextTool tt = new TextTool();
        // Textos posicionados por um ponto de referncia:
        String[] refs =
          new String[] { TextTool.NORTH, TextTool.SOUTH, TextTool.EAST, TextTool.WEST, TextTool.NORTH_EAST, TextTool.NORTH_WEST,
          TextTool.SOUTH_EAST, TextTool.SOUTH_WEST, TextTool.CENTER };
        String[] aligns =
          new String[] { TextTool.ALIGN_LEFT, TextTool.ALIGN_CENTER, TextTool.ALIGN_RIGHT };
        for (int i = 0; i < refs.length; i++) {
          for (int j = 0; j < aligns.length; j++) {
            String text =
              "Referncia: " + refs[i] + "\nAlinhamento: " + aligns[j];
            tt.getBBox(g2d, text, pt, refs[i], rect);
            if (rect.getMinY() < pt.getY()) {
              pt.setLocation(pt.getX(), pt.getY() + pt.getY() - rect.getMinY());
              tt.getBBox(g2d, text, pt, refs[i], rect);
            }
            if (rect.getMaxY() > y + h) {
              pt.setLocation(pt.getX() + dx, y);
              tt.getBBox(g2d, text, pt, refs[i], rect);
            }
            g2d.draw(rect);
            dot.setFrame(pt.getX() - 1, pt.getY() - 1, 3, 3);
            g2d.fill(dot);
            tt.draw(g2d, text, pt, refs[i], aligns[j]);
            pt.setLocation(pt.getX(), rect.getMaxY() + 5);
          }
          pt.setLocation(pt.getX(), pt.getY() + df);
        }
        // Texto posicionado pela caixa envolvente:
        String text =
          "Isso  um texto\t\t que deve ser*\n"
            + "escrito em vrias\t linhas.*\n"
            + "Todas as linhas\t terminam*\n"
            + "com um '*' para\t\t que seja possvel*\n"
            + "ver se as quebras\t foram feitas*\n"
            + "e/ou se houve perda\t de texto*\n"
            + "nas linhas muito\t longas.*\n"
            + "Essa linha, por exemplo  muito longa e no deve caber na caixa fornecida... (mas termina com um * ainda assim!)*\n"
            + "*\n"
            + "A linha anterior s tem o *.*\n"
            + "Agora repete tudo de novo:*\n"
            + "Isso  um texto que deve ser*\n"
            + "escrito em vrias linhas.*\n"
            + "Todas as linhas terminam*\n"
            + "com um '*' para que seja possvel*\n"
            + "ver se as quebras foram feitas*\n"
            + "e/ou se houve perda de texto*\n"
            + "nas linhas muito longas.*\n"
            + "Essa linha, por exemplo  muito longa e no deve caber na caixa fornecida... (mas termina com um * ainda assim!)*\n"
            + "*\n" + "A linha anterior s tem o *.*\n";

        rect.setRect(rect.getMaxX() + df, rect.getMaxY() + df, Math.min(x + w
          - rect.getMaxX() - df, 200), Math.min(y + h - rect.getMaxY() - df,
          100));
        g2d.draw(rect);
        if (page > lastPage) {
          lastPage = page;
          lastPos = pos;
        }
        pos = tt.draw(g2d, text, lastPos, rect, TextTool.WRAP_WORD, TextTool.ALIGN_LEFT);
        finished = (pos == text.length());
        return PAGE_EXISTS;
      }
    });
    job.printDialog();
    job.print();
    System.out.println("Digite <enter> para terminar.");
    System.in.read();
    System.exit(0);
  }
}
